/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.CharStreams;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.messages.Version;
import com.spotify.helios.agent.InterruptingScheduledService;
import com.spotify.helios.common.descriptors.DockerVersion;
import com.spotify.helios.common.descriptors.HostInfo;
import com.spotify.helios.servicescommon.coordination.NodeUpdaterFactory;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperNodeUpdater;
import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class HostInfoReporter
extends InterruptingScheduledService {
    public static final int DEFAULT_INTERVAL = 1;
    public static final TimeUnit DEFAUL_TIMEUNIT = TimeUnit.MINUTES;
    private final OperatingSystemMXBean operatingSystemMXBean;
    private final ZooKeeperNodeUpdater nodeUpdater;
    private final int interval;
    private final TimeUnit timeUnit;
    private final DockerClient dockerClient;

    HostInfoReporter(Builder builder) {
        this.operatingSystemMXBean = (OperatingSystemMXBean)Preconditions.checkNotNull((Object)builder.operatingSystemMXBean, (Object)"operatingSystemMXBean");
        this.nodeUpdater = builder.nodeUpdaterFactory.create(Paths.statusHostInfo((String)Preconditions.checkNotNull((Object)builder.host, (Object)"host")));
        this.dockerClient = (DockerClient)Preconditions.checkNotNull((Object)builder.dockerClient, (Object)"dockerClient");
        this.interval = builder.interval;
        this.timeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)builder.timeUnit), (Object)"timeUnit"));
    }

    @Override
    protected void runOneIteration() throws InterruptedException {
        String hostname = this.exec("uname -n").trim();
        String uname = this.exec("uname -a").trim();
        HostInfo hostInfo = HostInfo.newBuilder().setArchitecture(this.operatingSystemMXBean.getArch()).setCpus(Runtime.getRuntime().availableProcessors()).setHostname(hostname).setLoadAvg(this.operatingSystemMXBean.getSystemLoadAverage()).setOsName(this.operatingSystemMXBean.getName()).setOsVersion(this.operatingSystemMXBean.getVersion()).setMemoryFreeBytes(this.operatingSystemMXBean.getFreePhysicalMemorySize()).setMemoryTotalBytes(this.operatingSystemMXBean.getTotalPhysicalMemorySize()).setSwapFreeBytes(this.operatingSystemMXBean.getFreeSwapSpaceSize()).setSwapTotalBytes(this.operatingSystemMXBean.getTotalSwapSpaceSize()).setUname(uname).setDockerVersion(this.dockerVersion()).build();
        this.nodeUpdater.update(hostInfo.toJsonBytes());
    }

    private DockerVersion dockerVersion() throws InterruptedException {
        try {
            Version version = this.dockerClient.version();
            return version == null ? null : this.dockerVersion(version);
        }
        catch (DockerException e) {
            return null;
        }
    }

    private DockerVersion dockerVersion(Version version) {
        return DockerVersion.builder().apiVersion(version.apiVersion()).arch(version.arch()).gitCommit(version.gitCommit()).goVersion(version.goVersion()).kernelVersion(version.kernelVersion()).os(version.os()).version(version.version()).build();
    }

    @Override
    protected ScheduledFuture<?> schedule(Runnable runnable, ScheduledExecutorService executorService) {
        return executorService.scheduleWithFixedDelay(runnable, 0L, this.interval, this.timeUnit);
    }

    private String exec(String command) {
        try {
            Process process = Runtime.getRuntime().exec(command);
            return CharStreams.toString((Readable)new InputStreamReader(process.getInputStream(), Charsets.UTF_8));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private NodeUpdaterFactory nodeUpdaterFactory;
        private OperatingSystemMXBean operatingSystemMXBean;
        private String host;
        private DockerClient dockerClient;
        private int interval = 1;
        private TimeUnit timeUnit = DEFAUL_TIMEUNIT;

        Builder() {
        }

        public Builder setNodeUpdaterFactory(NodeUpdaterFactory nodeUpdaterFactory) {
            this.nodeUpdaterFactory = nodeUpdaterFactory;
            return this;
        }

        public Builder setOperatingSystemMXBean(OperatingSystemMXBean operatingSystemMXBean) {
            this.operatingSystemMXBean = operatingSystemMXBean;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setDockerClient(DockerClient dockerClient) {
            this.dockerClient = dockerClient;
            return this;
        }

        public Builder setInterval(int interval) {
            this.interval = interval;
            return this;
        }

        public Builder setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public HostInfoReporter build() {
            return new HostInfoReporter(this);
        }
    }
}

