/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.DockerTimeoutException;
import com.spotify.helios.servicescommon.RiemannFacade;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public abstract class MonitoredDockerClient {
    private MonitoredDockerClient() {
    }

    public static DockerClient wrap(RiemannFacade riemann, DockerClient client) {
        return (DockerClient)Proxy.newProxyInstance(MonitoredDockerClient.class.getClassLoader(), new Class[]{DockerClient.class}, (InvocationHandler)new MonitoringInvocationHandler(riemann, client));
    }

    private static class MonitoringInvocationHandler
    implements InvocationHandler {
        private final RiemannFacade riemann;
        private final DockerClient client;

        public MonitoringInvocationHandler(RiemannFacade riemann, DockerClient client) {
            this.riemann = riemann;
            this.client = client;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this.client, args);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof DockerException) {
                    String tag = e.getCause() instanceof DockerTimeoutException ? "timeout" : "error";
                    this.riemann.event().service("helios-agent/docker").tags(new String[]{"docker", tag, method.getName()}).send();
                }
                throw e.getCause();
            }
        }
    }
}

