/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.spotify.helios.common.descriptors.PortMapping;
import java.util.Map;
import java.util.Set;

public class PortAllocator {
    private int i;
    private final int start;
    private final int end;

    public PortAllocator(int start, int end) {
        this.start = start;
        this.end = end;
        this.i = start;
    }

    public Map<String, Integer> allocate(Map<String, PortMapping> ports, Set<Integer> used) {
        return this.allocate0(ports, Sets.newHashSet(used));
    }

    private Map<String, Integer> allocate0(Map<String, PortMapping> mappings, Set<Integer> used) {
        Integer externalPort;
        PortMapping portMapping;
        String name;
        ImmutableMap.Builder allocation = ImmutableMap.builder();
        for (Map.Entry<String, PortMapping> entry : mappings.entrySet()) {
            name = entry.getKey();
            portMapping = entry.getValue();
            externalPort = portMapping.getExternalPort();
            if (externalPort == null) continue;
            if (used.contains(externalPort)) {
                return null;
            }
            used.add(externalPort);
            allocation.put((Object)name, (Object)externalPort);
        }
        for (Map.Entry<String, PortMapping> entry : mappings.entrySet()) {
            name = entry.getKey();
            portMapping = entry.getValue();
            externalPort = portMapping.getExternalPort();
            if (externalPort != null) continue;
            Integer port = null;
            for (int i = this.start; i < this.end; ++i) {
                int candidate = this.next();
                if (used.contains(candidate)) continue;
                port = candidate;
                break;
            }
            if (port == null) {
                return null;
            }
            used.add(port);
            allocation.put((Object)name, port);
        }
        return allocation.build();
    }

    private int next() {
        if (this.i == this.end) {
            this.i = this.start;
        }
        return this.i++;
    }
}

