/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import javax.annotation.Nullable;

public class Result<V>
implements FutureCallback<V> {
    private volatile boolean done;
    private volatile V result;
    private volatile Throwable exception;

    public Result(ListenableFuture<V> future) {
        Futures.addCallback(future, (FutureCallback)this);
    }

    public void onSuccess(@Nullable V r) {
        this.done = true;
        this.result = r;
    }

    public void onFailure(Throwable t) {
        this.done = true;
        this.exception = t;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isSuccess() {
        return this.isDone() && this.result != null;
    }

    public boolean isFailure() {
        return this.isDone() && this.exception != null;
    }

    public V getResult() {
        return this.result;
    }

    public Throwable getException() {
        return this.exception;
    }

    public static <V> Result<V> of(ListenableFuture<V> future) {
        return new Result<V>(future);
    }
}

