/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Preconditions;
import com.spotify.docker.client.DockerClient;
import com.spotify.helios.agent.AgentModel;
import com.spotify.helios.agent.ContainerDecorator;
import com.spotify.helios.agent.DefaultStatusUpdater;
import com.spotify.helios.agent.FlapController;
import com.spotify.helios.agent.RestartPolicy;
import com.spotify.helios.agent.Supervisor;
import com.spotify.helios.agent.TaskConfig;
import com.spotify.helios.agent.TaskMonitor;
import com.spotify.helios.agent.TaskRunnerFactory;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.serviceregistration.ServiceRegistrar;
import com.spotify.helios.servicescommon.statistics.SupervisorMetrics;
import java.util.List;
import java.util.Map;

public class SupervisorFactory {
    private final AgentModel model;
    private final DockerClient dockerClient;
    private final String namespace;
    private final Map<String, String> envVars;
    private final ServiceRegistrar registrar;
    private final ContainerDecorator containerDecorator;
    private final String host;
    private final SupervisorMetrics metrics;
    private final String defaultRegistrationDomain;
    private final List<String> dns;

    public SupervisorFactory(AgentModel model, DockerClient dockerClient, Map<String, String> envVars, ServiceRegistrar registrar, ContainerDecorator containerDecorator, String host, SupervisorMetrics supervisorMetrics, String namespace, String defaultRegistrationDomain, List<String> dns) {
        this.dockerClient = dockerClient;
        this.namespace = namespace;
        this.model = (AgentModel)Preconditions.checkNotNull((Object)model, (Object)"model");
        this.envVars = (Map)Preconditions.checkNotNull(envVars, (Object)"envVars");
        this.registrar = registrar;
        this.containerDecorator = containerDecorator;
        this.host = host;
        this.metrics = supervisorMetrics;
        this.defaultRegistrationDomain = (String)Preconditions.checkNotNull((Object)defaultRegistrationDomain, (Object)"defaultRegistrationDomain");
        this.dns = (List)Preconditions.checkNotNull(dns, (Object)"dns");
    }

    public Supervisor create(Job job, String existingContainerId, Map<String, Integer> ports, Supervisor.Listener listener) {
        RestartPolicy policy = RestartPolicy.newBuilder().build();
        TaskConfig taskConfig = TaskConfig.builder().host(this.host).job(job).ports(ports).envVars(this.envVars).containerDecorator(this.containerDecorator).namespace(this.namespace).defaultRegistrationDomain(this.defaultRegistrationDomain).dns(this.dns).build();
        TaskStatus.Builder taskStatus = TaskStatus.newBuilder().setJob(job).setEnv(taskConfig.containerEnv()).setPorts(taskConfig.ports());
        DefaultStatusUpdater statusUpdater = new DefaultStatusUpdater(this.model, taskStatus);
        FlapController flapController = FlapController.create();
        TaskMonitor taskMonitor = new TaskMonitor(job.getId(), flapController, statusUpdater);
        TaskRunnerFactory runnerFactory = TaskRunnerFactory.builder().config(taskConfig).registrar(this.registrar).dockerClient(this.dockerClient).listener(taskMonitor).build();
        return Supervisor.newBuilder().setJob(job).setExistingContainerId(existingContainerId).setDockerClient(this.dockerClient).setRestartPolicy(policy).setMetrics(this.metrics).setListener(listener).setRunnerFactory(runnerFactory).setStatusUpdater(statusUpdater).setMonitor(taskMonitor).build();
    }
}

