/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.helios.agent.ContainerDecorator;
import com.spotify.helios.common.descriptors.Job;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SyslogRedirectingContainerDecorator
implements ContainerDecorator {
    private final String syslogHostPort;

    public SyslogRedirectingContainerDecorator(String syslogHostPort) {
        this.syslogHostPort = syslogHostPort;
    }

    @Override
    public void decorateHostConfig(HostConfig.Builder hostConfig) {
        ArrayList binds = Lists.newArrayList();
        if (hostConfig.binds() != null) {
            binds.addAll(hostConfig.binds());
        }
        binds.add("/usr/lib/helios:/helios:ro");
        hostConfig.binds((List)binds);
    }

    @Override
    public void decorateContainerConfig(Job job, ImageInfo imageInfo, ContainerConfig.Builder containerConfig) {
        ContainerConfig imageConfig = imageInfo.containerConfig();
        ArrayList entrypoint = Lists.newArrayList((Object[])new String[]{"/helios/syslog-redirector", "-h", this.syslogHostPort, "-n", job.getId().toString(), "--"});
        if (imageConfig.entrypoint() != null) {
            entrypoint.addAll(imageConfig.entrypoint());
        }
        containerConfig.entrypoint((List)entrypoint);
        HashSet volumes = Sets.newHashSet();
        if (containerConfig.volumes() != null) {
            volumes.addAll(containerConfig.volumes());
        }
        volumes.add("/helios");
        containerConfig.volumes((Set)volumes);
    }
}

