/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.docker.client.messages.PortBinding;
import com.spotify.helios.agent.ContainerDecorator;
import com.spotify.helios.agent.NoOpContainerDecorator;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.ServiceEndpoint;
import com.spotify.helios.common.descriptors.ServicePorts;
import com.spotify.helios.serviceregistration.ServiceRegistration;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskConfig {
    private static final Logger log = LoggerFactory.getLogger(TaskConfig.class);
    private static final Pattern CONTAINER_NAME_FORBIDDEN = Pattern.compile("[^a-zA-Z0-9_-]");
    private static final int HOST_NAME_MAX = 32;
    private final String host;
    private final Map<String, Integer> ports;
    private final Job job;
    private final Map<String, String> envVars;
    private final ContainerDecorator containerDecorator;
    private final String namespace;
    private final String defaultRegistrationDomain;
    private final List<String> dns;

    private TaskConfig(Builder builder) {
        this.host = (String)Preconditions.checkNotNull((Object)builder.host, (Object)"host");
        this.ports = (Map)Preconditions.checkNotNull((Object)builder.ports, (Object)"ports");
        this.job = (Job)Preconditions.checkNotNull((Object)builder.job, (Object)"job");
        this.envVars = (Map)Preconditions.checkNotNull((Object)builder.envVars, (Object)"envVars");
        this.containerDecorator = (ContainerDecorator)Preconditions.checkNotNull((Object)builder.containerDecorator, (Object)"containerDecorator");
        this.namespace = (String)Preconditions.checkNotNull((Object)builder.namespace, (Object)"namespace");
        this.defaultRegistrationDomain = (String)Preconditions.checkNotNull((Object)builder.defaultRegistrationDomain, (Object)"defaultRegistrationDomain");
        this.dns = (List)Preconditions.checkNotNull((Object)builder.dns, (Object)"dns");
    }

    public String containerName() {
        String shortId = this.job.getId().toShortString();
        String escaped = CONTAINER_NAME_FORBIDDEN.matcher(shortId).replaceAll("_");
        String random = Integer.toHexString(new SecureRandom().nextInt());
        return this.namespace + "-" + escaped + "_" + random;
    }

    public ContainerConfig containerConfig(ImageInfo imageInfo) {
        ContainerConfig.Builder builder = ContainerConfig.builder();
        builder.image(this.job.getImage());
        builder.cmd(this.job.getCommand());
        builder.env(this.containerEnvStrings());
        builder.exposedPorts(this.containerExposedPorts());
        builder.hostname(this.containerHostname(this.job.getId().getName() + "_" + this.job.getId().getVersion()));
        builder.domainname(this.host);
        builder.volumes(this.volumes());
        this.containerDecorator.decorateContainerConfig(this.job, imageInfo, builder);
        return builder.build();
    }

    public Map<String, PortMapping> ports() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry e : this.job.getPorts().entrySet()) {
            PortMapping mapping = (PortMapping)e.getValue();
            builder.put(e.getKey(), (Object)(mapping.hasExternalPort() ? mapping : mapping.withExternalPort((Integer)Preconditions.checkNotNull((Object)this.ports.get(e.getKey())))));
        }
        return builder.build();
    }

    public Map<String, String> containerEnv() {
        HashMap env = Maps.newHashMap(this.envVars);
        env.putAll(this.job.getEnv());
        return env;
    }

    public ServiceRegistration registration() throws InterruptedException {
        ServiceRegistration.Builder builder = ServiceRegistration.newBuilder();
        for (Map.Entry entry : this.job.getRegistration().entrySet()) {
            ServiceEndpoint registration = (ServiceEndpoint)entry.getKey();
            ServicePorts servicePorts = (ServicePorts)entry.getValue();
            for (String portName : servicePorts.getPorts().keySet()) {
                PortMapping mapping = (PortMapping)this.job.getPorts().get(portName);
                if (mapping == null) {
                    log.error("no '{}' port mapped for registration: '{}'", (Object)portName, (Object)registration);
                    continue;
                }
                Integer externalPort = mapping.getExternalPort() != null ? mapping.getExternalPort() : this.ports.get(portName);
                if (externalPort == null) {
                    log.error("no external '{}' port for registration: '{}'", (Object)portName, (Object)registration);
                    continue;
                }
                builder.endpoint(registration.getName(), registration.getProtocol(), externalPort.intValue(), this.fullyQualifiedRegistrationDomain(), this.host);
            }
        }
        return builder.build();
    }

    private String fullyQualifiedRegistrationDomain() {
        if (this.job.getRegistrationDomain().endsWith(".")) {
            return this.job.getRegistrationDomain();
        }
        if ("".equals(this.job.getRegistrationDomain())) {
            return this.defaultRegistrationDomain;
        }
        return this.job.getRegistrationDomain() + "." + this.defaultRegistrationDomain;
    }

    private Set<String> containerExposedPorts() {
        HashSet ports = Sets.newHashSet();
        for (Map.Entry entry : this.job.getPorts().entrySet()) {
            PortMapping mapping = (PortMapping)entry.getValue();
            ports.add(this.containerPort(mapping.getInternalPort(), mapping.getProtocol()));
        }
        return ports;
    }

    private String containerHostname(String name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        String hostname = sb.toString();
        if (hostname.length() <= 32) {
            return hostname;
        }
        String tail = hostname.substring(hostname.length() - 16);
        String head = hostname.substring(0, 16);
        return head + tail;
    }

    private List<String> containerEnvStrings() {
        Map<String, String> env = this.containerEnv();
        ArrayList envList = Lists.newArrayList();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            envList.add(entry.getKey() + '=' + entry.getValue());
        }
        return envList;
    }

    private Map<String, List<PortBinding>> portBindings() {
        HashMap bindings = Maps.newHashMap();
        for (Map.Entry e : this.job.getPorts().entrySet()) {
            PortMapping mapping = (PortMapping)e.getValue();
            PortBinding binding = new PortBinding();
            Integer externalPort = mapping.getExternalPort();
            if (externalPort == null) {
                binding.hostPort(this.ports.get(e.getKey()).toString());
            } else {
                binding.hostPort(externalPort.toString());
            }
            String entry = this.containerPort(mapping.getInternalPort(), mapping.getProtocol());
            bindings.put(entry, Arrays.asList(binding));
        }
        return bindings;
    }

    public HostConfig hostConfig() {
        HostConfig.Builder builder = HostConfig.builder().binds(this.binds()).portBindings(this.portBindings()).dns(this.dns);
        this.containerDecorator.decorateHostConfig(builder);
        return builder.build();
    }

    private Set<String> volumes() {
        ImmutableSet.Builder volumes = ImmutableSet.builder();
        for (Map.Entry entry : this.job.getVolumes().entrySet()) {
            String path = (String)entry.getKey();
            String source = (String)entry.getValue();
            if (!Strings.isNullOrEmpty((String)source)) continue;
            volumes.add((Object)path);
        }
        return volumes.build();
    }

    private List<String> binds() {
        ImmutableList.Builder binds = ImmutableList.builder();
        for (Map.Entry entry : this.job.getVolumes().entrySet()) {
            String path = (String)entry.getKey();
            String source = (String)entry.getValue();
            if (Strings.isNullOrEmpty((String)source)) continue;
            binds.add((Object)(source + ":" + path));
        }
        return binds.build();
    }

    private String containerPort(int port, String protocol) {
        return port + "/" + protocol;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String containerImage() {
        return this.job.getImage();
    }

    public String name() {
        return this.job.getId().toShortString();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("job", (Object)this.job).add("host", (Object)this.host).add("ports", this.ports).add("envVars", this.envVars).add("containerDecorator", (Object)this.containerDecorator).add("defaultRegistrationDomain", (Object)this.defaultRegistrationDomain).toString();
    }

    public static class Builder {
        private String host;
        private Job job;
        private Map<String, Integer> ports = Collections.emptyMap();
        private Map<String, String> envVars = Collections.emptyMap();
        private ContainerDecorator containerDecorator = new NoOpContainerDecorator();
        private String namespace;
        private String defaultRegistrationDomain = "";
        private List<String> dns = Collections.emptyList();

        private Builder() {
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder job(Job job) {
            this.job = job;
            return this;
        }

        public Builder defaultRegistrationDomain(String domain) {
            this.defaultRegistrationDomain = (String)Preconditions.checkNotNull((Object)domain, (Object)"domain");
            return this;
        }

        public Builder ports(Map<String, Integer> ports) {
            this.ports = ports;
            return this;
        }

        public Builder envVars(Map<String, String> envVars) {
            this.envVars = envVars;
            return this;
        }

        public Builder containerDecorator(ContainerDecorator containerDecorator) {
            this.containerDecorator = containerDecorator;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder dns(List<String> dns) {
            this.dns = dns;
            return this;
        }

        public TaskConfig build() {
            return new TaskConfig(this);
        }
    }
}

