/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.util.concurrent.MoreExecutors;
import com.spotify.docker.client.ImageNotFoundException;
import com.spotify.docker.client.ImagePullFailedException;
import com.spotify.helios.agent.FlapController;
import com.spotify.helios.agent.StatusUpdater;
import com.spotify.helios.agent.TaskRunner;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.descriptors.ThrottleState;
import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskMonitor
implements TaskRunner.Listener,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(TaskMonitor.class);
    private final JobId jobId;
    private final ScheduledExecutorService scheduler;
    private final FlapController flapController;
    private final StatusUpdater statusUpdater;
    private volatile ScheduledFuture<?> flapTimeout;
    private ThrottleState imageFailure;
    private ThrottleState throttle = ThrottleState.NO;

    public TaskMonitor(JobId jobId, FlapController flapController, StatusUpdater statusUpdater) {
        this.jobId = jobId;
        this.flapController = flapController;
        this.statusUpdater = statusUpdater;
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        executor.setKeepAliveTime(5L, TimeUnit.SECONDS);
        executor.allowCoreThreadTimeOut(true);
        this.scheduler = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)executor, (long)0L, (TimeUnit)TimeUnit.SECONDS);
    }

    public ThrottleState throttle() {
        return this.throttle;
    }

    @Override
    public void close() {
        this.scheduler.shutdownNow();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.scheduler.isShutdown()) {
            log.error("task monitor not properly closed: {}", (Object)this.jobId);
        }
    }

    @Override
    public void failed(Throwable t) {
        if (t instanceof InterruptedException) {
            return;
        }
        if (t instanceof ImageNotFoundException) {
            this.imageFailure(ThrottleState.IMAGE_MISSING);
        } else if (t instanceof ImagePullFailedException) {
            this.imageFailure(ThrottleState.IMAGE_PULL_FAILED);
        }
        this.updateState(TaskStatus.State.FAILED);
    }

    @Override
    public void pulling() {
        this.updateState(TaskStatus.State.PULLING_IMAGE);
    }

    @Override
    public void creating() {
        this.updateState(TaskStatus.State.CREATING);
    }

    @Override
    public void created(String containerId) {
        this.resetImageFailure();
        this.statusUpdater.setContainerId(containerId);
    }

    @Override
    public void starting() {
        this.resetImageFailure();
        this.updateState(TaskStatus.State.STARTING);
    }

    @Override
    public void started() {
        this.resetImageFailure();
    }

    @Override
    public void running() {
        this.flapController.started();
        this.resetImageFailure();
        this.updateState(TaskStatus.State.RUNNING);
    }

    @Override
    public void exited(int code) {
        this.flapController.exited();
        this.updateThrottle();
        this.updateState(TaskStatus.State.EXITED);
    }

    private void imageFailure(ThrottleState imageFailure) {
        this.imageFailure = imageFailure;
        this.updateThrottle();
    }

    private void resetImageFailure() {
        this.imageFailure = null;
        this.updateThrottle();
    }

    private boolean updateThrottle() {
        boolean updated;
        ThrottleState newThrottle;
        boolean flapping = this.flapController.isFlapping();
        if (this.imageFailure != null) {
            newThrottle = this.imageFailure;
        } else {
            ThrottleState throttleState = newThrottle = flapping ? ThrottleState.FLAPPING : ThrottleState.NO;
        }
        if (!Objects.equals(this.throttle, newThrottle)) {
            log.info("throttle state change: {}: {} -> {}", new Object[]{this.jobId, this.throttle, newThrottle});
            this.throttle = newThrottle;
            this.statusUpdater.setThrottleState(this.throttle);
            updated = true;
        } else {
            updated = false;
        }
        if (flapping) {
            if (this.flapTimeout != null) {
                this.flapTimeout.cancel(false);
            }
            this.flapTimeout = this.scheduler.schedule(new UpdateThrottle(), this.flapController.millisLeftToUnflap(), TimeUnit.MILLISECONDS);
        }
        return updated;
    }

    private void updateState(TaskStatus.State state) {
        this.statusUpdater.setState(state);
        try {
            this.statusUpdater.update();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private class UpdateThrottle
    implements Runnable {
        private UpdateThrottle() {
        }

        @Override
        public void run() {
            if (TaskMonitor.this.updateThrottle()) {
                try {
                    TaskMonitor.this.statusUpdater.update();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

