/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.spotify.docker.client.ContainerNotFoundException;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerExit;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.helios.agent.Result;
import com.spotify.helios.agent.TaskConfig;
import com.spotify.helios.common.HeliosRuntimeException;
import com.spotify.helios.serviceregistration.NopServiceRegistrar;
import com.spotify.helios.serviceregistration.ServiceRegistrar;
import com.spotify.helios.serviceregistration.ServiceRegistrationHandle;
import com.spotify.helios.servicescommon.InterruptingExecutionThreadService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TaskRunner
extends InterruptingExecutionThreadService {
    private static final Logger log = LoggerFactory.getLogger(TaskRunner.class);
    private final long delayMillis;
    private final SettableFuture<Integer> result = SettableFuture.create();
    private final TaskConfig config;
    private final DockerClient docker;
    private final String existingContainerId;
    private final Listener listener;
    private final ServiceRegistrar registrar;
    private Optional<ServiceRegistrationHandle> serviceRegistrationHandle;

    private TaskRunner(Builder builder) {
        super("TaskRunner(" + builder.taskConfig.name() + ")");
        this.delayMillis = builder.delayMillis;
        this.config = (TaskConfig)Preconditions.checkNotNull((Object)builder.taskConfig, (Object)"config");
        this.docker = (DockerClient)Preconditions.checkNotNull((Object)builder.docker, (Object)"docker");
        this.listener = (Listener)Preconditions.checkNotNull((Object)builder.listener, (Object)"listener");
        this.existingContainerId = builder.existingContainerId;
        this.registrar = (ServiceRegistrar)Preconditions.checkNotNull((Object)builder.registrar, (Object)"registrar");
        this.serviceRegistrationHandle = Optional.absent();
    }

    public Result<Integer> result() {
        return Result.of(this.result);
    }

    public ListenableFuture<Integer> resultFuture() {
        return this.result;
    }

    public boolean unregister() {
        if (this.serviceRegistrationHandle.isPresent()) {
            this.registrar.unregister((ServiceRegistrationHandle)this.serviceRegistrationHandle.get());
            this.serviceRegistrationHandle = Optional.absent();
            return true;
        }
        return false;
    }

    protected void run() {
        try {
            int exitCode = this.run0();
            this.result.set((Object)exitCode);
        }
        catch (Exception e) {
            this.listener.failed(e);
            this.result.setException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run0() throws InterruptedException, DockerException {
        ContainerExit exit;
        Thread.sleep(this.delayMillis);
        String containerId = this.createAndStartContainer();
        this.listener.running();
        this.serviceRegistrationHandle = Optional.fromNullable((Object)this.registrar.register(this.config.registration()));
        try {
            exit = this.docker.waitContainer(containerId);
        }
        finally {
            this.unregister();
        }
        log.info("container exited: {}: {}: {}", new Object[]{this.config, containerId, exit.statusCode()});
        this.listener.exited(exit.statusCode());
        return exit.statusCode();
    }

    private String createAndStartContainer() throws DockerException, InterruptedException {
        ContainerInfo info = this.getContainerInfo(this.existingContainerId);
        if (info != null && info.state().running().booleanValue()) {
            return this.existingContainerId;
        }
        String image = this.config.containerImage();
        this.pullImage(image);
        return this.startContainer(image);
    }

    private String startContainer(String image) throws InterruptedException, DockerException {
        ImageInfo imageInfo = this.docker.inspectImage(image);
        if (imageInfo == null) {
            throw new HeliosRuntimeException("docker inspect image returned null on image " + image);
        }
        ContainerConfig containerConfig = this.config.containerConfig(imageInfo);
        String name = this.config.containerName();
        this.listener.creating();
        ContainerCreation container = this.docker.createContainer(containerConfig, name);
        log.info("created container: {}: {}, {}", new Object[]{this.config, container, containerConfig});
        this.listener.created(container.id());
        HostConfig hostConfig = this.config.hostConfig();
        log.info("starting container: {}: {} {}", new Object[]{this.config, container.id(), hostConfig});
        this.listener.starting();
        this.docker.startContainer(container.id(), hostConfig);
        log.info("started container: {}: {}", (Object)this.config, (Object)container.id());
        this.listener.started();
        return container.id();
    }

    private ContainerInfo getContainerInfo(String existingContainerId) throws DockerException, InterruptedException {
        if (existingContainerId == null) {
            return null;
        }
        log.info("inspecting container: {}: {}", (Object)this.config, (Object)existingContainerId);
        try {
            return this.docker.inspectContainer(existingContainerId);
        }
        catch (ContainerNotFoundException e) {
            return null;
        }
    }

    private void pullImage(String image) throws DockerException, InterruptedException {
        this.listener.pulling();
        try {
            this.docker.pull(image);
        }
        catch (DockerException e) {
            log.warn("Pulling image {} failed", (Object)image, (Object)e);
        }
        this.docker.inspectImage(image);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class NopListener
    implements Listener {
        @Override
        public void failed(Throwable t) {
        }

        @Override
        public void pulling() {
        }

        @Override
        public void creating() {
        }

        @Override
        public void created(String containerId) {
        }

        @Override
        public void starting() {
        }

        @Override
        public void started() {
        }

        @Override
        public void running() {
        }

        @Override
        public void exited(int code) {
        }
    }

    public static class Builder {
        private long delayMillis;
        private TaskConfig taskConfig;
        private DockerClient docker;
        private String existingContainerId;
        private Listener listener;
        public ServiceRegistrar registrar = new NopServiceRegistrar();

        private Builder() {
        }

        public Builder delayMillis(long delayMillis) {
            this.delayMillis = delayMillis;
            return this;
        }

        public Builder config(TaskConfig config) {
            this.taskConfig = config;
            return this;
        }

        public Builder docker(DockerClient docker) {
            this.docker = docker;
            return this;
        }

        public Builder existingContainerId(String existingContainerId) {
            this.existingContainerId = existingContainerId;
            return this;
        }

        public Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder registrar(ServiceRegistrar registrar) {
            this.registrar = registrar;
            return this;
        }

        public TaskRunner build() {
            return new TaskRunner(this);
        }
    }

    public static interface Listener {
        public void failed(Throwable var1);

        public void pulling();

        public void creating();

        public void created(String var1);

        public void starting();

        public void started();

        public void running();

        public void exited(int var1);
    }
}

