/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.spotify.docker.client.DockerClient;
import com.spotify.helios.agent.TaskConfig;
import com.spotify.helios.agent.TaskRunner;
import com.spotify.helios.serviceregistration.ServiceRegistrar;
import java.util.Arrays;
import java.util.List;

public class TaskRunnerFactory {
    private final TaskConfig taskConfig;
    private final DockerClient docker;
    private final ServiceRegistrar registrar;
    private final List<TaskRunner.Listener> listeners;

    public TaskRunnerFactory(Builder builder) {
        this.taskConfig = (TaskConfig)Preconditions.checkNotNull((Object)builder.config, (Object)"config");
        this.registrar = (ServiceRegistrar)Preconditions.checkNotNull((Object)builder.registrar, (Object)"registrar");
        this.docker = (DockerClient)Preconditions.checkNotNull((Object)builder.docker, (Object)"docker");
        this.listeners = (List)Preconditions.checkNotNull((Object)builder.listeners, (Object)"listeners");
    }

    public TaskRunner create(long delay, String containerId, TaskRunner.Listener listener) {
        return TaskRunner.builder().delayMillis(delay).config(this.taskConfig).docker(this.docker).existingContainerId(containerId).listener(new BroadcastingListener(Iterables.concat(this.listeners, Arrays.asList(listener)))).registrar(this.registrar).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private class BroadcastingListener
    implements TaskRunner.Listener {
        private final Iterable<TaskRunner.Listener> listeners;

        private BroadcastingListener(Iterable<TaskRunner.Listener> listeners) {
            this.listeners = listeners;
        }

        @Override
        public void failed(Throwable t) {
            for (TaskRunner.Listener l : this.listeners) {
                l.failed(t);
            }
        }

        @Override
        public void pulling() {
            for (TaskRunner.Listener l : this.listeners) {
                l.pulling();
            }
        }

        @Override
        public void creating() {
            for (TaskRunner.Listener l : this.listeners) {
                l.creating();
            }
        }

        @Override
        public void created(String containerId) {
            for (TaskRunner.Listener l : this.listeners) {
                l.created(containerId);
            }
        }

        @Override
        public void starting() {
            for (TaskRunner.Listener l : this.listeners) {
                l.starting();
            }
        }

        @Override
        public void started() {
            for (TaskRunner.Listener l : this.listeners) {
                l.started();
            }
        }

        @Override
        public void running() {
            for (TaskRunner.Listener l : this.listeners) {
                l.running();
            }
        }

        @Override
        public void exited(int code) {
            for (TaskRunner.Listener l : this.listeners) {
                l.exited(code);
            }
        }
    }

    public static class Builder {
        private TaskConfig config;
        private DockerClient docker;
        private ServiceRegistrar registrar;
        private List<TaskRunner.Listener> listeners = Lists.newArrayList();

        private Builder() {
        }

        public Builder config(TaskConfig config) {
            this.config = config;
            return this;
        }

        public Builder registrar(ServiceRegistrar registrar) {
            this.registrar = registrar;
            return this;
        }

        public Builder dockerClient(DockerClient docker) {
            this.docker = docker;
            return this;
        }

        public Builder listener(TaskRunner.Listener listener) {
            this.listeners.add(listener);
            return this;
        }

        public TaskRunnerFactory build() {
            return new TaskRunnerFactory(this);
        }
    }
}

