/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master;

import com.spotify.helios.common.HeliosException;
import com.spotify.helios.common.descriptors.JobId;

public class JobPortAllocationConflictException
extends HeliosException {
    private final JobId id;
    private final JobId conflictingId;
    private final String host;
    private final int port;

    public JobPortAllocationConflictException(JobId id, JobId conflictingId, String host, int port) {
        super(String.format("Allocation of port %d for job %s collides with job %s on host %s", port, id, conflictingId, host));
        this.id = id;
        this.conflictingId = conflictingId;
        this.host = host;
        this.port = port;
    }

    public JobId getId() {
        return this.id;
    }

    public JobId getConflictingId() {
        return this.conflictingId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

