/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master;

import com.spotify.helios.common.LoggingConfig;
import com.spotify.helios.master.MasterConfig;
import com.spotify.helios.master.MasterParser;
import com.spotify.helios.master.MasterService;
import com.spotify.helios.servicescommon.ServiceMain;
import com.spotify.helios.servicescommon.coordination.CuratorClientFactory;
import com.spotify.helios.servicescommon.coordination.CuratorClientFactoryImpl;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.config.Environment;
import com.yammer.dropwizard.json.ObjectMapperFactory;
import com.yammer.dropwizard.validation.Validator;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterMain
extends ServiceMain {
    private static final Logger log = LoggerFactory.getLogger(MasterMain.class);
    private final MasterConfig masterConfig;
    private final CuratorClientFactory curatorClientFactory;
    private MasterService service;

    public MasterMain(String[] args) throws ArgumentParserException {
        this((CuratorClientFactory)new CuratorClientFactoryImpl(), new MasterParser(args));
    }

    public MasterMain(CuratorClientFactory curatorClientFactory, String[] args) throws ArgumentParserException {
        this(curatorClientFactory, new MasterParser(args));
    }

    public MasterMain(CuratorClientFactory curatorClientFactory, MasterParser parser) {
        this(curatorClientFactory, parser.getMasterConfig(), parser.getLoggingConfig());
    }

    public MasterMain(CuratorClientFactory curatorClientFactory, MasterConfig masterConfig, LoggingConfig loggingConfig) {
        super(loggingConfig, masterConfig.getSentryDsn());
        this.masterConfig = masterConfig;
        this.curatorClientFactory = curatorClientFactory;
    }

    protected void startUp() throws Exception {
        Environment environment = new Environment("helios-master", (Configuration)this.masterConfig, new ObjectMapperFactory(), new Validator());
        this.service = new MasterService(this.masterConfig, environment, this.curatorClientFactory);
        this.service.startAsync().awaitRunning();
    }

    protected void shutDown() throws Exception {
        this.service.stopAsync().awaitTerminated();
    }

    public static void main(String ... args) {
        try {
            MasterMain main = new MasterMain(args);
            main.startAsync().awaitRunning();
            main.awaitTerminated();
        }
        catch (Throwable e) {
            log.error("Uncaught exception", e);
            System.exit(1);
        }
        System.exit(0);
    }
}

