/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master;

import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.TaskStatusEvent;
import com.spotify.helios.master.HostNotFoundException;
import com.spotify.helios.master.HostStillInUseException;
import com.spotify.helios.master.JobAlreadyDeployedException;
import com.spotify.helios.master.JobDoesNotExistException;
import com.spotify.helios.master.JobExistsException;
import com.spotify.helios.master.JobNotDeployedException;
import com.spotify.helios.master.JobPortAllocationConflictException;
import com.spotify.helios.master.JobStillDeployedException;
import java.util.List;
import java.util.Map;

public interface MasterModel {
    public void registerHost(String var1, String var2);

    public void deregisterHost(String var1) throws HostNotFoundException, HostStillInUseException;

    public List<String> listHosts();

    public HostStatus getHostStatus(String var1);

    public void addJob(Job var1) throws JobExistsException;

    public Job getJob(JobId var1);

    public Map<JobId, Job> getJobs();

    public JobStatus getJobStatus(JobId var1);

    public Job removeJob(JobId var1) throws JobDoesNotExistException, JobStillDeployedException;

    public void deployJob(String var1, Deployment var2) throws HostNotFoundException, JobAlreadyDeployedException, JobDoesNotExistException, JobPortAllocationConflictException;

    public Deployment getDeployment(String var1, JobId var2);

    public Deployment undeployJob(String var1, JobId var2) throws HostNotFoundException, JobNotDeployedException;

    public void updateDeployment(String var1, Deployment var2) throws HostNotFoundException, JobNotDeployedException;

    public List<String> getRunningMasters();

    public List<TaskStatusEvent> getJobHistory(JobId var1) throws JobDoesNotExistException;
}

