/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master;

import com.spotify.helios.master.MasterConfig;
import com.spotify.helios.servicescommon.ServiceParser;
import com.yammer.dropwizard.config.HttpConfiguration;
import java.net.InetSocketAddress;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;

public class MasterParser
extends ServiceParser {
    private final MasterConfig masterConfig;
    private Argument httpArg;
    private Argument adminArg;

    public MasterParser(String ... args) throws ArgumentParserException {
        super("helios-master", "Spotify Helios Master", args);
        Namespace options = this.getNamespace();
        InetSocketAddress httpAddress = this.parseSocketAddress(options.getString(this.httpArg.getDest()));
        MasterConfig config = new MasterConfig().setZooKeeperConnectString(this.getZooKeeperConnectString()).setZooKeeperSessionTimeoutMillis(this.getZooKeeperSessionTimeoutMillis()).setZooKeeperConnectionTimeoutMillis(this.getZooKeeperConnectionTimeoutMillis()).setDomain(this.getDomain()).setName(this.getName()).setStatsdHostPort(this.getStatsdHostPort()).setRiemannHostPort(this.getRiemannHostPort()).setInhibitMetrics(this.getInhibitMetrics()).setSentryDsn(this.getSentryDsn()).setServiceRegistryAddress(this.getServiceRegistryAddress()).setServiceRegistrarPlugin(this.getServiceRegistrarPlugin());
        HttpConfiguration http = config.getHttpConfiguration();
        http.setPort(httpAddress.getPort());
        http.setBindHost(httpAddress.getHostString());
        http.setAdminPort(options.getInt(this.adminArg.getDest()).intValue());
        this.masterConfig = config;
    }

    @Override
    protected void addArgs(ArgumentParser parser) {
        this.httpArg = parser.addArgument(new String[]{"--http"}).setDefault((Object)"http://0.0.0.0:5801").help("http endpoint");
        this.adminArg = parser.addArgument(new String[]{"--admin"}).type(Integer.class).setDefault((Object)5802).help("admin http port");
    }

    public MasterConfig getMasterConfig() {
        return this.masterConfig;
    }
}

