/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master;

import ch.qos.logback.access.jetty.RequestLogImpl;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.common.util.concurrent.AbstractIdleService;
import com.spotify.helios.master.ExpiredJobReaper;
import com.spotify.helios.master.MasterConfig;
import com.spotify.helios.master.MasterZooKeeperRegistrar;
import com.spotify.helios.master.ZooKeeperMasterModel;
import com.spotify.helios.master.http.VersionResponseFilter;
import com.spotify.helios.master.metrics.ReportingResourceMethodDispatchAdapter;
import com.spotify.helios.master.resources.HistoryResource;
import com.spotify.helios.master.resources.HostsResource;
import com.spotify.helios.master.resources.JobsResource;
import com.spotify.helios.master.resources.MastersResource;
import com.spotify.helios.master.resources.VersionResource;
import com.spotify.helios.serviceregistration.ServiceRegistrar;
import com.spotify.helios.serviceregistration.ServiceRegistration;
import com.spotify.helios.servicescommon.ManagedStatsdReporter;
import com.spotify.helios.servicescommon.RiemannFacade;
import com.spotify.helios.servicescommon.RiemannHeartBeat;
import com.spotify.helios.servicescommon.RiemannSupport;
import com.spotify.helios.servicescommon.ServiceRegistrars;
import com.spotify.helios.servicescommon.ZooKeeperRegistrar;
import com.spotify.helios.servicescommon.coordination.CuratorClientFactory;
import com.spotify.helios.servicescommon.coordination.DefaultZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClientProvider;
import com.spotify.helios.servicescommon.coordination.ZooKeeperHealthChecker;
import com.spotify.helios.servicescommon.coordination.ZooKeeperModelReporter;
import com.spotify.helios.servicescommon.statistics.Metrics;
import com.spotify.helios.servicescommon.statistics.MetricsImpl;
import com.spotify.helios.servicescommon.statistics.NoopMetrics;
import com.yammer.dropwizard.config.ConfigurationException;
import com.yammer.dropwizard.config.Environment;
import com.yammer.dropwizard.config.RequestLogConfiguration;
import com.yammer.dropwizard.config.ServerFactory;
import com.yammer.dropwizard.lifecycle.Managed;
import com.yammer.dropwizard.lifecycle.ServerLifecycleListener;
import com.yammer.metrics.core.HealthCheck;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterService
extends AbstractIdleService {
    private static final Logger log = LoggerFactory.getLogger(MasterService.class);
    private final Server server;
    private final MasterConfig config;
    private final Environment environment;
    private final ServiceRegistrar registrar;
    private final RiemannFacade riemannFacade;
    private final ZooKeeperClient zooKeeperClient;
    private final ExpiredJobReaper expiredJobReaper;
    private final CuratorClientFactory curatorClientFactory;
    private ZooKeeperRegistrar zkRegistrar;

    public MasterService(MasterConfig config, Environment environment, CuratorClientFactory curatorClientFactory) throws ConfigurationException {
        Metrics metrics;
        this.config = config;
        this.environment = environment;
        this.curatorClientFactory = curatorClientFactory;
        MetricsRegistry metricsRegistry = com.yammer.metrics.Metrics.defaultRegistry();
        RiemannSupport riemannSupport = new RiemannSupport(metricsRegistry, config.getRiemannHostPort(), config.getName(), "helios-master");
        this.riemannFacade = riemannSupport.getFacade();
        log.info("Starting metrics");
        if (config.isInhibitMetrics()) {
            metrics = new NoopMetrics();
        } else {
            metrics = new MetricsImpl(metricsRegistry);
            metrics.start();
            environment.manage((Managed)riemannSupport);
            environment.manage((Managed)new ManagedStatsdReporter(config.getStatsdHostPort(), "helios-master", metricsRegistry));
        }
        this.zooKeeperClient = this.setupZookeeperClient(config);
        ZooKeeperModelReporter modelReporter = new ZooKeeperModelReporter(this.riemannFacade, metrics.getZooKeeperMetrics());
        ZooKeeperClientProvider zkClientProvider = new ZooKeeperClientProvider(this.zooKeeperClient, modelReporter);
        ZooKeeperMasterModel model = new ZooKeeperMasterModel(zkClientProvider);
        ZooKeeperHealthChecker zooKeeperHealthChecker = new ZooKeeperHealthChecker(this.zooKeeperClient, Paths.statusMasters(), this.riemannFacade, TimeUnit.MINUTES, 2L);
        environment.manage((Managed)zooKeeperHealthChecker);
        environment.addHealthCheck((HealthCheck)zooKeeperHealthChecker);
        environment.manage((Managed)new RiemannHeartBeat(TimeUnit.MINUTES, 2, this.riemannFacade));
        this.registrar = ServiceRegistrars.createServiceRegistrar(config.getServiceRegistrarPlugin(), config.getServiceRegistryAddress(), config.getDomain());
        this.expiredJobReaper = ExpiredJobReaper.newBuilder().setMasterModel(model).build();
        environment.addFilter(VersionResponseFilter.class, "/*");
        environment.addProvider((Object)new ReportingResourceMethodDispatchAdapter(metrics.getMasterMetrics()));
        environment.addResource((Object)new JobsResource(model, metrics.getMasterMetrics()));
        environment.addResource((Object)new HistoryResource(model, metrics.getMasterMetrics()));
        environment.addResource((Object)new HostsResource(model));
        environment.addResource((Object)new MastersResource(model));
        environment.addResource((Object)new VersionResource());
        RequestLogConfiguration requestLogConfiguration = config.getHttpConfiguration().getRequestLogConfiguration();
        requestLogConfiguration.getConsoleConfiguration().setEnabled(false);
        requestLogConfiguration.getSyslogConfiguration().setEnabled(false);
        requestLogConfiguration.getFileConfiguration().setEnabled(false);
        this.server = new ServerFactory(config.getHttpConfiguration(), environment.getName()).buildServer(environment);
        HandlerCollection handler = (HandlerCollection)this.server.getHandler();
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        RequestLogImpl requestLog = new RequestLogImpl();
        requestLog.setQuiet(true);
        requestLog.setResource("/logback-access.xml");
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        handler.addHandler((Handler)requestLogHandler);
        this.server.setHandler((Handler)handler);
    }

    protected void startUp() throws Exception {
        this.logBanner();
        this.zooKeeperClient.start();
        this.zkRegistrar.startAsync().awaitRunning();
        this.expiredJobReaper.startAsync().awaitRunning();
        try {
            this.server.start();
            for (ServerLifecycleListener listener : this.environment.getServerListeners()) {
                listener.serverStarted(this.server);
            }
        }
        catch (Exception e) {
            log.error("Unable to start server, shutting down", (Throwable)e);
            this.server.stop();
        }
        ServiceRegistration serviceRegistration = ServiceRegistration.newBuilder().endpoint("helios", "http", this.config.getHttpConfiguration().getPort(), this.config.getDomain(), this.config.getName()).build();
        this.registrar.register(serviceRegistration);
    }

    protected void shutDown() throws Exception {
        this.server.stop();
        this.server.join();
        this.registrar.close();
        this.expiredJobReaper.stopAsync().awaitTerminated();
        this.zkRegistrar.stopAsync().awaitTerminated();
        this.zooKeeperClient.close();
    }

    private void logBanner() {
        try {
            String banner = Resources.toString((URL)Resources.getResource((String)"banner.txt"), (Charset)Charsets.UTF_8);
            log.info("\n{}", (Object)banner);
        }
        catch (IOException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    private ZooKeeperClient setupZookeeperClient(MasterConfig config) {
        ExponentialBackoffRetry zooKeeperRetryPolicy = new ExponentialBackoffRetry(1000, 3);
        CuratorFramework curator = this.curatorClientFactory.newClient(config.getZooKeeperConnectString(), config.getZooKeeperSessionTimeoutMillis(), config.getZooKeeperConnectionTimeoutMillis(), (RetryPolicy)zooKeeperRetryPolicy);
        DefaultZooKeeperClient client = new DefaultZooKeeperClient(curator);
        this.zkRegistrar = new ZooKeeperRegistrar(client, new MasterZooKeeperRegistrar(config.getName()));
        return client;
    }
}

