/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.spotify.helios.common.HeliosRuntimeException;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.AgentInfo;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostInfo;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.Task;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.descriptors.TaskStatusEvent;
import com.spotify.helios.master.HostNotFoundException;
import com.spotify.helios.master.HostStillInUseException;
import com.spotify.helios.master.JobAlreadyDeployedException;
import com.spotify.helios.master.JobDoesNotExistException;
import com.spotify.helios.master.JobExistsException;
import com.spotify.helios.master.JobNotDeployedException;
import com.spotify.helios.master.JobPortAllocationConflictException;
import com.spotify.helios.master.JobStillDeployedException;
import com.spotify.helios.master.MasterModel;
import com.spotify.helios.servicescommon.coordination.Node;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClientProvider;
import com.spotify.helios.servicescommon.coordination.ZooKeeperOperation;
import com.spotify.helios.servicescommon.coordination.ZooKeeperOperations;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperMasterModel
implements MasterModel {
    private static final Comparator<TaskStatusEvent> EVENT_COMPARATOR = new Comparator<TaskStatusEvent>(){

        @Override
        public int compare(TaskStatusEvent arg0, TaskStatusEvent arg1) {
            if (arg1.getTimestamp() > arg0.getTimestamp()) {
                return -1;
            }
            if (arg1.getTimestamp() == arg0.getTimestamp()) {
                return 0;
            }
            return 1;
        }
    };
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperMasterModel.class);
    public static final Map<JobId, TaskStatus> EMPTY_STATUSES = Collections.emptyMap();
    public static final TypeReference<HostInfo> HOST_INFO_TYPE = new TypeReference<HostInfo>(){};
    public static final TypeReference<AgentInfo> AGENT_INFO_TYPE = new TypeReference<AgentInfo>(){};
    public static final TypeReference<Map<String, String>> STRING_MAP_TYPE = new TypeReference<Map<String, String>>(){};
    private final ZooKeeperClientProvider provider;

    public ZooKeeperMasterModel(ZooKeeperClientProvider provider) {
        this.provider = provider;
    }

    @Override
    public void registerHost(String host, String id) {
        log.info("registering host: {}", (Object)host);
        ZooKeeperClient client = this.provider.get("registerHost");
        try {
            client.ensurePath(Paths.configHost(host));
            client.ensurePath(Paths.configHostJobs(host));
            client.ensurePath(Paths.configHostPorts(host));
            client.ensurePath(Paths.statusHost(host));
            client.ensurePath(Paths.statusHostJobs(host));
            client.createAndSetData(Paths.configHostId(host), id.getBytes(Charsets.UTF_8));
        }
        catch (Exception e) {
            throw new HeliosRuntimeException("registering host " + host + " failed", (Throwable)e);
        }
    }

    @Override
    public List<String> listHosts() {
        try {
            return this.provider.get("listHosts").getChildren(Paths.configHosts());
        }
        catch (KeeperException.NoNodeException e) {
            return Collections.emptyList();
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("listing hosts failed", (Throwable)e);
        }
    }

    @Override
    public List<String> getRunningMasters() {
        ZooKeeperClient client = this.provider.get("getRunningMasters");
        try {
            List<String> masters = client.getChildren(Paths.statusMaster());
            ImmutableList.Builder upMasters = ImmutableList.builder();
            for (String master : masters) {
                if (client.exists(Paths.statusMasterUp(master)) == null) continue;
                upMasters.add((Object)master);
            }
            return upMasters.build();
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("listing masters failed", (Throwable)e);
        }
    }

    @Override
    public void deregisterHost(String host) throws HostNotFoundException, HostStillInUseException {
        log.info("deregistering host: {}", (Object)host);
        ZooKeeperClient client = this.provider.get("deregisterHost");
        try {
            ArrayList operations = Lists.newArrayList();
            List<JobId> jobs = this.listHostJobs(client, host);
            if (jobs == null && client.exists(Paths.configHost(host)) == null) {
                throw new HostNotFoundException("host [" + host + "] does not exist");
            }
            for (JobId job : jobs) {
                String hostJobPath = Paths.configHostJob(host, job);
                List<String> nodes = client.listRecursive(hostJobPath);
                for (String node : Lists.reverse(nodes)) {
                    operations.add(ZooKeeperOperations.delete(node));
                }
                if (client.exists(Paths.configJobHost(job, host)) != null) {
                    operations.add(ZooKeeperOperations.delete(Paths.configJobHost(job, host)));
                }
                try {
                    List<String> history = client.listRecursive(Paths.historyJobHost(job, host));
                    for (String s : Lists.reverse(history)) {
                        operations.add(ZooKeeperOperations.delete(s));
                    }
                }
                catch (KeeperException.NoNodeException ignore) {
                }
            }
            operations.add(ZooKeeperOperations.delete(Paths.configHostJobs(host)));
            try {
                List<String> nodes = client.listRecursive(Paths.statusHost(host));
                for (String node : Lists.reverse(nodes)) {
                    operations.add(ZooKeeperOperations.delete(node));
                }
            }
            catch (KeeperException.NoNodeException ignore) {
                // empty catch block
            }
            try {
                List<String> ports = client.getChildren(Paths.configHostPorts(host));
                for (String port : ports) {
                    operations.add(ZooKeeperOperations.delete(Paths.configHostPort(host, Integer.valueOf(port))));
                }
                operations.add(ZooKeeperOperations.delete(Paths.configHostPorts(host)));
            }
            catch (KeeperException.NoNodeException ignore) {
                // empty catch block
            }
            String idPath = Paths.configHostId(host);
            if (client.exists(idPath) != null) {
                operations.add(ZooKeeperOperations.delete(idPath));
            }
            operations.add(ZooKeeperOperations.delete(Paths.configHost(host)));
            client.transaction(operations);
        }
        catch (KeeperException.NotEmptyException e) {
            HostStatus hostStatus = this.getHostStatus(host);
            ImmutableList jobs = hostStatus != null ? ImmutableList.copyOf(hostStatus.getJobs().keySet()) : Collections.emptyList();
            throw new HostStillInUseException(host, (List<JobId>)jobs);
        }
        catch (KeeperException.NoNodeException e) {
            throw new HostNotFoundException(host);
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException((Throwable)e);
        }
    }

    @Override
    public void addJob(Job job) throws JobExistsException {
        log.info("adding job: {}", (Object)job);
        JobId id = job.getId();
        UUID operationId = UUID.randomUUID();
        String creationPath = Paths.configJobCreation(id, operationId);
        ZooKeeperClient client = this.provider.get("addJob");
        try {
            try {
                client.ensurePath(Paths.historyJob(id));
                client.transaction(ZooKeeperOperations.create(Paths.configJob(id), (Descriptor)job), ZooKeeperOperations.create(Paths.configJobRefShort(id), (Descriptor)id), ZooKeeperOperations.create(Paths.configJobHosts(id)), ZooKeeperOperations.create(creationPath));
            }
            catch (KeeperException.NodeExistsException e) {
                if (client.exists(creationPath) != null) {
                    return;
                }
                throw new JobExistsException(id.toString());
            }
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("adding job " + job + " failed", (Throwable)e);
        }
    }

    @Override
    public List<TaskStatusEvent> getJobHistory(JobId jobId) throws JobDoesNotExistException {
        List<String> hosts;
        Job descriptor = this.getJob(jobId);
        if (descriptor == null) {
            throw new JobDoesNotExistException(jobId);
        }
        ZooKeeperClient client = this.provider.get("getJobHistory");
        try {
            hosts = client.getChildren(Paths.historyJobHosts(jobId));
        }
        catch (KeeperException.NoNodeException e) {
            return Collections.emptyList();
        }
        catch (KeeperException e) {
            throw Throwables.propagate((Throwable)e);
        }
        ArrayList jsEvents = Lists.newArrayList();
        for (String host : hosts) {
            List<String> events;
            try {
                events = client.getChildren(Paths.historyJobHostEvents(jobId, host));
            }
            catch (KeeperException e) {
                throw Throwables.propagate((Throwable)e);
            }
            for (String event : events) {
                try {
                    byte[] data = client.getData(Paths.historyJobHostEventsTimestamp(jobId, host, Long.valueOf(event)));
                    TaskStatus status = (TaskStatus)Json.read((byte[])data, TaskStatus.class);
                    jsEvents.add(new TaskStatusEvent(status, Long.valueOf(event).longValue(), host));
                }
                catch (KeeperException.NoNodeException e) {
                }
                catch (IOException | KeeperException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }
        return Ordering.from(EVENT_COMPARATOR).sortedCopy((Iterable)jsEvents);
    }

    @Override
    public Job getJob(JobId id) {
        log.debug("getting job: {}", (Object)id);
        ZooKeeperClient client = this.provider.get("getJob");
        return this.getJob(client, id);
    }

    private Job getJob(ZooKeeperClient client, JobId id) {
        String path = Paths.configJob(id);
        try {
            byte[] data = client.getData(path);
            return (Job)Json.read((byte[])data, Job.class);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("getting job " + id + " failed", e);
        }
    }

    @Override
    public Map<JobId, Job> getJobs() {
        log.debug("getting jobs");
        String folder = Paths.configJobs();
        ZooKeeperClient client = this.provider.get("getJobs");
        try {
            List<String> ids;
            try {
                ids = client.getChildren(folder);
            }
            catch (KeeperException.NoNodeException e) {
                return Maps.newHashMap();
            }
            HashMap descriptors = Maps.newHashMap();
            for (String id : ids) {
                JobId jobId = JobId.fromString((String)id);
                String path = Paths.configJob(jobId);
                byte[] data = client.getData(path);
                Job descriptor = (Job)Descriptor.parse((byte[])data, Job.class);
                descriptors.put(descriptor.getId(), descriptor);
            }
            return descriptors;
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("getting jobs failed", e);
        }
    }

    @Override
    public JobStatus getJobStatus(JobId jobId) {
        List<String> hosts;
        ZooKeeperClient client = this.provider.get("getJobStatus");
        Job job = this.getJob(client, jobId);
        if (job == null) {
            return null;
        }
        try {
            hosts = this.listJobHosts(client, jobId);
        }
        catch (JobDoesNotExistException e) {
            return null;
        }
        ImmutableMap.Builder deployments = ImmutableMap.builder();
        ImmutableMap.Builder taskStatuses = ImmutableMap.builder();
        for (String host : hosts) {
            Deployment deployment;
            TaskStatus taskStatus = this.getTaskStatus(client, host, jobId);
            if (taskStatus != null) {
                taskStatuses.put((Object)host, (Object)taskStatus);
            }
            if ((deployment = this.getDeployment(host, jobId)) == null) continue;
            deployments.put((Object)host, (Object)deployment);
        }
        ImmutableMap deploymentsMap = deployments.build();
        return JobStatus.newBuilder().setJob(job).setDeployments((Map)deploymentsMap).setTaskStatuses((Map)taskStatuses.build()).build();
    }

    private List<String> listJobHosts(ZooKeeperClient client, JobId jobId) throws JobDoesNotExistException {
        List<String> hosts;
        try {
            hosts = client.getChildren(Paths.configJobHosts(jobId));
        }
        catch (KeeperException.NoNodeException e) {
            throw new JobDoesNotExistException(jobId);
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("failed to list hosts for job: " + jobId, (Throwable)e);
        }
        return hosts;
    }

    @Override
    public Job removeJob(JobId id) throws JobDoesNotExistException, JobStillDeployedException {
        log.info("removing job: id={}", (Object)id);
        ZooKeeperClient client = this.provider.get("removeJob");
        Job job = this.getJob(client, id);
        if (job == null) {
            throw new JobDoesNotExistException(id);
        }
        try {
            ImmutableList.Builder operations = ImmutableList.builder();
            UUID jobCreationOperationId = this.getJobCreation(client, id);
            if (jobCreationOperationId != null) {
                operations.add((Object)ZooKeeperOperations.delete(Paths.configJobCreation(id, jobCreationOperationId)));
            }
            operations.add((Object[])new ZooKeeperOperation[]{ZooKeeperOperations.delete(Paths.configJobHosts(id)), ZooKeeperOperations.delete(Paths.configJobRefShort(id)), ZooKeeperOperations.delete(Paths.configJob(id))});
            client.transaction((List<ZooKeeperOperation>)operations.build());
        }
        catch (KeeperException.NoNodeException e) {
            throw new JobDoesNotExistException(id);
        }
        catch (KeeperException.NotEmptyException e) {
            throw new JobStillDeployedException(id, this.listJobHosts(client, id));
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("removing job " + id + " failed", (Throwable)e);
        }
        return job;
    }

    private UUID getJobCreation(ZooKeeperClient client, JobId id) throws KeeperException {
        String parent = Paths.configHostJobCreationParent(id);
        List<String> children = client.getChildren(parent);
        for (String child : children) {
            if (!Paths.isConfigJobCreation(id, parent, child)) continue;
            return Paths.configJobCreationId(id, parent, child);
        }
        return null;
    }

    @Override
    public void deployJob(String host, Deployment deployment) throws JobDoesNotExistException, JobAlreadyDeployedException, HostNotFoundException, JobPortAllocationConflictException {
        ZooKeeperClient client = this.provider.get("deployJob");
        this.deployJobRetry(client, host, deployment, 0);
    }

    private void deployJobRetry(ZooKeeperClient client, String host, Deployment deployment, int count) throws JobDoesNotExistException, JobAlreadyDeployedException, HostNotFoundException, JobPortAllocationConflictException {
        if (count == 3) {
            throw new HeliosRuntimeException("3 failures (possibly concurrent modifications) while deploying. Giving up.");
        }
        log.info("deploying {}: {} (retry={})", new Object[]{deployment, host, count});
        JobId id = deployment.getJobId();
        Job job = this.getJob(id);
        if (job == null) {
            throw new JobDoesNotExistException(id);
        }
        UUID operationId = UUID.randomUUID();
        String jobPath = Paths.configJob(id);
        String taskPath = Paths.configHostJob(host, id);
        String taskCreationPath = Paths.configHostJobCreation(host, id, operationId);
        List<Integer> staticPorts = this.staticPorts(job);
        HashMap portNodes = Maps.newHashMap();
        byte[] idJson = id.toJsonBytes();
        for (int port : staticPorts) {
            String path = Paths.configHostPort(host, port);
            portNodes.put(path, idJson);
        }
        Task task = new Task(job, deployment.getGoal());
        ArrayList operations = Lists.newArrayList((Object[])new ZooKeeperOperation[]{ZooKeeperOperations.check(jobPath), ZooKeeperOperations.create(portNodes), ZooKeeperOperations.create(Paths.configJobHost(id, host))});
        try {
            Node existing = client.getNode(taskPath);
            byte[] bytes = existing.getBytes();
            Task readTask = (Task)Json.read((byte[])bytes, Task.class);
            if (readTask.getGoal() != Goal.UNDEPLOY) {
                throw new JobAlreadyDeployedException(host, id);
            }
            operations.add(ZooKeeperOperations.check(taskPath, existing.getStat().getVersion()));
            operations.add(ZooKeeperOperations.set(taskPath, (Descriptor)task));
        }
        catch (KeeperException.NoNodeException e) {
            operations.add(ZooKeeperOperations.create(taskPath, (Descriptor)task));
            operations.add(ZooKeeperOperations.create(taskCreationPath));
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("reading existing task description failed", e);
        }
        try {
            client.transaction(operations);
            log.info("deployed {}: {} (retry={})", new Object[]{deployment, host, count});
        }
        catch (KeeperException.NoNodeException e) {
            this.assertJobExists(client, id);
            this.assertHostExists(client, host);
            this.deployJobRetry(client, host, deployment, count + 1);
        }
        catch (KeeperException.NodeExistsException e) {
            try {
                if (client.exists(taskCreationPath) != null) {
                    return;
                }
            }
            catch (KeeperException ex) {
                throw new HeliosRuntimeException("checking job deployment failed", (Throwable)ex);
            }
            try {
                if (client.stat(taskPath) != null) {
                    throw new JobAlreadyDeployedException(host, id);
                }
            }
            catch (KeeperException ex) {
                throw new HeliosRuntimeException("checking job deployment failed", (Throwable)e);
            }
            for (int port : staticPorts) {
                String path = Paths.configHostPort(host, port);
                try {
                    if (client.stat(path) == null) continue;
                    byte[] b = client.getData(path);
                    JobId existingJobId = (JobId)Descriptor.parse((byte[])b, JobId.class);
                    throw new JobPortAllocationConflictException(id, existingJobId, host, port);
                }
                catch (IOException | KeeperException ex) {
                    throw new HeliosRuntimeException("checking port allocations failed", (Throwable)e);
                }
            }
            throw new HeliosRuntimeException("deploying job failed", (Throwable)e);
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("deploying job failed", (Throwable)e);
        }
    }

    private void assertJobExists(ZooKeeperClient client, JobId id) throws JobDoesNotExistException {
        try {
            String path = Paths.configJob(id);
            if (client.stat(path) == null) {
                throw new JobDoesNotExistException(id);
            }
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("checking job existence failed", (Throwable)e);
        }
    }

    private List<Integer> staticPorts(Job job) {
        ArrayList staticPorts = Lists.newArrayList();
        for (PortMapping portMapping : job.getPorts().values()) {
            if (portMapping.getExternalPort() == null) continue;
            staticPorts.add(portMapping.getExternalPort());
        }
        return staticPorts;
    }

    @Override
    public void updateDeployment(String host, Deployment deployment) throws HostNotFoundException, JobNotDeployedException {
        log.info("updating deployment {}: {}", (Object)deployment, (Object)host);
        ZooKeeperClient client = this.provider.get("updateDeployment");
        JobId jobId = deployment.getJobId();
        Job job = this.getJob(client, jobId);
        if (job == null) {
            throw new JobNotDeployedException(host, jobId);
        }
        this.assertHostExists(client, host);
        this.assertTaskExists(client, host, deployment.getJobId());
        String path = Paths.configHostJob(host, jobId);
        Task task = new Task(job, deployment.getGoal());
        try {
            client.setData(path, task.toJsonBytes());
        }
        catch (Exception e) {
            throw new HeliosRuntimeException("updating deployment " + deployment + " on host " + host + " failed", (Throwable)e);
        }
    }

    private void assertHostExists(ZooKeeperClient client, String host) throws HostNotFoundException {
        try {
            client.getData(Paths.configHost(host));
        }
        catch (KeeperException.NoNodeException e) {
            throw new HostNotFoundException(host, e);
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException((Throwable)e);
        }
    }

    private void assertTaskExists(ZooKeeperClient client, String host, JobId jobId) throws JobNotDeployedException {
        try {
            client.getData(Paths.configHostJob(host, jobId));
        }
        catch (KeeperException.NoNodeException e) {
            throw new JobNotDeployedException(host, jobId);
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException((Throwable)e);
        }
    }

    @Override
    public Deployment getDeployment(String host, JobId jobId) {
        String path = Paths.configHostJob(host, jobId);
        ZooKeeperClient client = this.provider.get("getDeployment");
        try {
            byte[] data = client.getData(path);
            Task task = (Task)Descriptor.parse((byte[])data, Task.class);
            return Deployment.of((JobId)jobId, (Goal)task.getGoal());
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("getting deployment failed", e);
        }
    }

    @Override
    public HostStatus getHostStatus(String host) {
        Stat stat;
        ZooKeeperClient client = this.provider.get("getHostStatus");
        try {
            stat = client.exists(Paths.configHostId(host));
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("Failed to check host status", (Throwable)e);
        }
        if (stat == null) {
            return null;
        }
        boolean up = this.checkHostUp(client, host);
        HostInfo hostInfo = this.getHostInfo(client, host);
        AgentInfo agentInfo = this.getAgentInfo(client, host);
        Map<JobId, Deployment> tasks = this.getTasks(client, host);
        Map<JobId, TaskStatus> statuses = this.getTaskStatuses(client, host);
        Map<String, String> environment = this.getEnvironment(client, host);
        return HostStatus.newBuilder().setJobs(tasks).setStatuses((Map)Optional.fromNullable(statuses).or(EMPTY_STATUSES)).setHostInfo(hostInfo).setAgentInfo(agentInfo).setStatus(up ? HostStatus.Status.UP : HostStatus.Status.DOWN).setEnvironment(environment).build();
    }

    private <T> T tryGetEntity(ZooKeeperClient client, String path, TypeReference<T> type, String name) {
        try {
            byte[] data = client.getData(path);
            return (T)Json.read((byte[])data, type);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("reading " + name + " info failed", e);
        }
    }

    private Map<String, String> getEnvironment(ZooKeeperClient client, String host) {
        return this.tryGetEntity(client, Paths.statusHostEnvVars(host), STRING_MAP_TYPE, "environment");
    }

    private AgentInfo getAgentInfo(ZooKeeperClient client, String host) {
        return this.tryGetEntity(client, Paths.statusHostAgentInfo(host), AGENT_INFO_TYPE, "agent info");
    }

    private HostInfo getHostInfo(ZooKeeperClient client, String host) {
        return this.tryGetEntity(client, Paths.statusHostInfo(host), HOST_INFO_TYPE, "host info");
    }

    private boolean checkHostUp(ZooKeeperClient client, String host) {
        try {
            Stat stat = client.exists(Paths.statusHostUp(host));
            return stat != null;
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("getting host " + host + " up status failed", (Throwable)e);
        }
    }

    private Map<JobId, TaskStatus> getTaskStatuses(ZooKeeperClient client, String host) {
        HashMap statuses = Maps.newHashMap();
        List<JobId> jobIds = this.listHostJobs(client, host);
        for (JobId jobId : jobIds) {
            TaskStatus status = this.getTaskStatus(client, host, jobId);
            if (status != null) {
                statuses.put(jobId, status);
                continue;
            }
            log.debug("Task {} status missing for host {}", (Object)jobId, (Object)host);
        }
        return statuses;
    }

    private List<JobId> listHostJobs(ZooKeeperClient client, String host) {
        List<String> jobIdStrings;
        String folder = Paths.statusHostJobs(host);
        try {
            jobIdStrings = client.getChildren(folder);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("List tasks for host failed: " + host, (Throwable)e);
        }
        ImmutableList.Builder jobIds = ImmutableList.builder();
        for (String jobIdString : jobIdStrings) {
            jobIds.add((Object)JobId.fromString((String)jobIdString));
        }
        return jobIds.build();
    }

    @Nullable
    private TaskStatus getTaskStatus(ZooKeeperClient client, String host, JobId jobId) {
        String containerPath = Paths.statusHostJob(host, jobId);
        try {
            byte[] data = client.getData(containerPath);
            return (TaskStatus)Descriptor.parse((byte[])data, TaskStatus.class);
        }
        catch (KeeperException.NoNodeException ignored) {
            return null;
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("Getting task " + jobId + " status " + "for host " + host + " failed", e);
        }
    }

    private Map<JobId, Deployment> getTasks(ZooKeeperClient client, String host) {
        HashMap jobs = Maps.newHashMap();
        try {
            List<String> jobIds;
            String folder = Paths.configHostJobs(host);
            try {
                jobIds = client.getChildren(folder);
            }
            catch (KeeperException.NoNodeException e) {
                return null;
            }
            for (String jobIdString : jobIds) {
                JobId jobId = JobId.fromString((String)jobIdString);
                String containerPath = Paths.configHostJob(host, jobId);
                try {
                    byte[] data = client.getData(containerPath);
                    Task task = (Task)Descriptor.parse((byte[])data, Task.class);
                    jobs.put(jobId, Deployment.of((JobId)jobId, (Goal)task.getGoal()));
                }
                catch (KeeperException.NoNodeException ignored) {
                    log.debug("deployment config node disappeared: {}", (Object)jobIdString);
                }
            }
        }
        catch (IOException | KeeperException e) {
            throw new HeliosRuntimeException("getting deployment config failed", e);
        }
        return jobs;
    }

    @Override
    public Deployment undeployJob(String host, JobId jobId) throws HostNotFoundException, JobNotDeployedException {
        log.info("undeploying {}: {}", (Object)jobId, (Object)host);
        ZooKeeperClient client = this.provider.get("undeployJob");
        this.assertHostExists(client, host);
        Deployment deployment = this.getDeployment(host, jobId);
        if (deployment == null) {
            throw new JobNotDeployedException(host, jobId);
        }
        Job job = this.getJob(client, jobId);
        String path = Paths.configHostJob(host, jobId);
        Task task = new Task(job, Goal.UNDEPLOY);
        ArrayList operations = Lists.newArrayList((Object[])new ZooKeeperOperation[]{ZooKeeperOperations.set(path, task.toJsonBytes()), ZooKeeperOperations.delete(Paths.configJobHost(jobId, host))});
        List<Integer> staticPorts = this.staticPorts(job);
        for (int port : staticPorts) {
            operations.add(ZooKeeperOperations.delete(Paths.configHostPort(host, port)));
        }
        try {
            client.transaction(operations);
        }
        catch (KeeperException.NoNodeException e) {
            if (e.getPath().equals(path)) {
                return deployment;
            }
            throw new HeliosRuntimeException("Removing deployment failed", (Throwable)e);
        }
        catch (KeeperException e) {
            throw new HeliosRuntimeException("Removing deployment failed", (Throwable)e);
        }
        return deployment;
    }
}

