/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master.resources;

import com.google.common.base.Optional;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.protocol.HostDeregisterResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.common.protocol.JobUndeployResponse;
import com.spotify.helios.common.protocol.SetGoalResponse;
import com.spotify.helios.master.HostNotFoundException;
import com.spotify.helios.master.HostStillInUseException;
import com.spotify.helios.master.JobAlreadyDeployedException;
import com.spotify.helios.master.JobDoesNotExistException;
import com.spotify.helios.master.JobNotDeployedException;
import com.spotify.helios.master.JobPortAllocationConflictException;
import com.spotify.helios.master.MasterModel;
import com.spotify.helios.master.http.PATCH;
import com.spotify.helios.master.http.Responses;
import com.yammer.metrics.annotation.ExceptionMetered;
import com.yammer.metrics.annotation.Timed;
import java.util.List;
import javax.validation.Valid;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/hosts")
public class HostsResource {
    private static final Logger log = LoggerFactory.getLogger(HostsResource.class);
    private final MasterModel model;

    public HostsResource(MasterModel model) {
        this.model = model;
    }

    @GET
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public List<String> list() {
        return this.model.listHosts();
    }

    @PUT
    @Path(value="{host}")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public Response.Status put(@PathParam(value="host") String host, @QueryParam(value="id") String id) {
        this.model.registerHost(host, id);
        log.info("added host {}", (Object)host);
        return Response.Status.OK;
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public HostDeregisterResponse delete(@PathParam(value="id") String host) {
        try {
            this.model.deregisterHost(host);
            return new HostDeregisterResponse(HostDeregisterResponse.Status.OK, host);
        }
        catch (HostNotFoundException e) {
            throw Responses.notFound(new HostDeregisterResponse(HostDeregisterResponse.Status.NOT_FOUND, host));
        }
        catch (HostStillInUseException e) {
            throw Responses.badRequest(new HostDeregisterResponse(HostDeregisterResponse.Status.JOBS_STILL_DEPLOYED, host));
        }
    }

    @GET
    @Path(value="{id}/status")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public Optional<HostStatus> hostStatus(@PathParam(value="id") String host) {
        return Optional.fromNullable((Object)this.model.getHostStatus(host));
    }

    @PUT
    @Path(value="/{host}/jobs/{job}")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public JobDeployResponse jobPut(@PathParam(value="host") String host, @PathParam(value="job") JobId jobId, @Valid Deployment deployment) {
        if (!jobId.isFullyQualified()) {
            throw Responses.badRequest(new JobDeployResponse(JobDeployResponse.Status.INVALID_ID, host, jobId));
        }
        try {
            this.model.deployJob(host, deployment);
            return new JobDeployResponse(JobDeployResponse.Status.OK, host, jobId);
        }
        catch (JobAlreadyDeployedException e) {
            throw Responses.badRequest(new JobDeployResponse(JobDeployResponse.Status.JOB_ALREADY_DEPLOYED, host, jobId));
        }
        catch (HostNotFoundException e) {
            throw Responses.badRequest(new JobDeployResponse(JobDeployResponse.Status.HOST_NOT_FOUND, host, jobId));
        }
        catch (JobDoesNotExistException e) {
            throw Responses.badRequest(new JobDeployResponse(JobDeployResponse.Status.JOB_NOT_FOUND, host, jobId));
        }
        catch (JobPortAllocationConflictException e) {
            throw Responses.badRequest(new JobDeployResponse(JobDeployResponse.Status.PORT_CONFLICT, host, jobId));
        }
    }

    @DELETE
    @Path(value="/{host}/jobs/{job}")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public JobUndeployResponse jobDelete(@PathParam(value="host") String host, @PathParam(value="job") JobId jobId) {
        if (!jobId.isFullyQualified()) {
            throw Responses.badRequest(new JobUndeployResponse(JobUndeployResponse.Status.INVALID_ID, host, jobId));
        }
        try {
            this.model.undeployJob(host, jobId);
            return new JobUndeployResponse(JobUndeployResponse.Status.OK, host, jobId);
        }
        catch (HostNotFoundException e) {
            throw Responses.notFound(new JobUndeployResponse(JobUndeployResponse.Status.HOST_NOT_FOUND, host, jobId));
        }
        catch (JobNotDeployedException e) {
            throw Responses.notFound(new JobUndeployResponse(JobUndeployResponse.Status.JOB_NOT_FOUND, host, jobId));
        }
    }

    @PATCH
    @Path(value="/{host}/jobs/{job}")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public SetGoalResponse jobPatch(@PathParam(value="host") String host, @PathParam(value="job") JobId jobId, @Valid Deployment deployment) {
        if (!deployment.getJobId().equals((Object)jobId)) {
            throw Responses.badRequest(new SetGoalResponse(SetGoalResponse.Status.ID_MISMATCH, host, jobId));
        }
        try {
            this.model.updateDeployment(host, deployment);
        }
        catch (HostNotFoundException e) {
            throw Responses.notFound(new SetGoalResponse(SetGoalResponse.Status.HOST_NOT_FOUND, host, jobId));
        }
        catch (JobNotDeployedException e) {
            throw Responses.notFound(new SetGoalResponse(SetGoalResponse.Status.JOB_NOT_DEPLOYED, host, jobId));
        }
        log.info("patched job {} on host {}", (Object)deployment, (Object)host);
        return new SetGoalResponse(SetGoalResponse.Status.OK, host, jobId);
    }

    @GET
    @Path(value="/{host}/jobs/{job}")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public Optional<Deployment> jobGet(@PathParam(value="host") String host, @PathParam(value="job") JobId jobId) {
        if (!jobId.isFullyQualified()) {
            throw Responses.badRequest();
        }
        return Optional.fromNullable((Object)this.model.getDeployment(host, jobId));
    }
}

