/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master.resources;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.spotify.helios.common.HeliosException;
import com.spotify.helios.common.JobValidator;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.JobDeleteResponse;
import com.spotify.helios.master.JobDoesNotExistException;
import com.spotify.helios.master.JobExistsException;
import com.spotify.helios.master.JobStillDeployedException;
import com.spotify.helios.master.MasterModel;
import com.spotify.helios.master.http.Responses;
import com.spotify.helios.servicescommon.statistics.MasterMetrics;
import com.sun.jersey.api.core.InjectParam;
import com.yammer.metrics.annotation.ExceptionMetered;
import com.yammer.metrics.annotation.Timed;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/jobs")
public class JobsResource {
    private static final Logger log = LoggerFactory.getLogger(JobsResource.class);
    private static final JobValidator JOB_VALIDATOR = new JobValidator();
    private final MasterModel model;
    private final MasterMetrics metrics;

    public JobsResource(MasterModel model, MasterMetrics metrics) {
        this.model = model;
        this.metrics = metrics;
    }

    @GET
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public Map<JobId, Job> list(@QueryParam(value="q") @DefaultValue(value="") String q) {
        Map<JobId, Job> allJobs = this.model.getJobs();
        if (q.isEmpty()) {
            this.metrics.jobsInJobList(allJobs.size());
            return allJobs;
        }
        HashMap filteredJobs = Maps.newHashMap();
        for (Map.Entry<JobId, Job> entry : allJobs.entrySet()) {
            if (!entry.getKey().toString().contains(q)) continue;
            filteredJobs.put(entry.getKey(), entry.getValue());
        }
        this.metrics.jobsInJobList(filteredJobs.size());
        return filteredJobs;
    }

    @Path(value="{id}")
    @GET
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public Optional<Job> get(@InjectParam @PathParam(value="id") @Valid JobId id) {
        if (!id.isFullyQualified()) {
            throw Responses.badRequest("Invalid id");
        }
        return Optional.fromNullable((Object)this.model.getJob(id));
    }

    @POST
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public CreateJobResponse post(@Valid Job job) {
        Set errors = JOB_VALIDATOR.validate(job);
        String jobIdString = job.toBuilder().build().getId().toString();
        if (!errors.isEmpty()) {
            throw Responses.badRequest(new CreateJobResponse(CreateJobResponse.Status.INVALID_JOB_DEFINITION, (List)ImmutableList.copyOf((Collection)errors), jobIdString));
        }
        try {
            this.model.addJob(job.toBuilder().build());
        }
        catch (JobExistsException e) {
            throw Responses.badRequest(new CreateJobResponse(CreateJobResponse.Status.JOB_ALREADY_EXISTS, (List)ImmutableList.of(), jobIdString));
        }
        log.info("created job: {}", (Object)job);
        return new CreateJobResponse(CreateJobResponse.Status.OK, (List)ImmutableList.of(), jobIdString);
    }

    @Path(value="{id}")
    @DELETE
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public JobDeleteResponse delete(@PathParam(value="id") @Valid JobId id) throws HeliosException {
        if (!id.isFullyQualified()) {
            throw Responses.badRequest("Invalid id");
        }
        try {
            this.model.removeJob(id);
            return new JobDeleteResponse(JobDeleteResponse.Status.OK);
        }
        catch (JobDoesNotExistException e) {
            throw Responses.notFound(new JobDeleteResponse(JobDeleteResponse.Status.JOB_NOT_FOUND));
        }
        catch (JobStillDeployedException e) {
            throw Responses.badRequest(new JobDeleteResponse(JobDeleteResponse.Status.STILL_IN_USE));
        }
    }

    @Path(value="{id}/status")
    @GET
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public Optional<JobStatus> statusGet(@PathParam(value="id") @Valid JobId id) {
        if (!id.isFullyQualified()) {
            throw Responses.badRequest("Invalid id");
        }
        return Optional.fromNullable((Object)this.model.getJobStatus(id));
    }
}

