/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.master.resources;

import com.spotify.helios.common.PomVersion;
import com.spotify.helios.common.VersionCheckResponse;
import com.spotify.helios.common.VersionCompatibility;
import com.yammer.metrics.annotation.ExceptionMetered;
import com.yammer.metrics.annotation.Timed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="version")
public class VersionResource {
    @GET
    @Produces(value={"text/plain"})
    @Timed
    @ExceptionMetered
    public String version() {
        return String.format("\"%s\"", "0.8.9");
    }

    @GET
    @Path(value="/check")
    @Produces(value={"application/json"})
    @Timed
    @ExceptionMetered
    public VersionCheckResponse versionCheck(@QueryParam(value="client") String client) {
        PomVersion clientVersion = PomVersion.parse((String)client);
        PomVersion serverVersion = PomVersion.parse((String)"0.8.9");
        VersionCompatibility.Status status = VersionCompatibility.getStatus((PomVersion)serverVersion, (PomVersion)clientVersion);
        return new VersionCheckResponse(status, serverVersion, "0.8.9");
    }
}

