/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import java.net.URI;

public class DockerHost {
    public static final int DEFAULT_PORT = 2375;
    public static final String DEFAULT_HOST = "localhost";
    private final String host;
    private final URI uri;
    private final String address;
    private final int port;

    private DockerHost(String endpoint) {
        String stripped = endpoint.replaceAll(".*://", "");
        HostAndPort hostAndPort = HostAndPort.fromString((String)stripped);
        String hostText = hostAndPort.getHostText();
        this.port = hostAndPort.getPortOrDefault(DockerHost.defaultPort());
        this.address = Strings.isNullOrEmpty((String)hostText) ? DEFAULT_HOST : hostText;
        this.host = this.address + ":" + this.port;
        this.uri = URI.create("http://" + this.address + ":" + this.port);
    }

    public String host() {
        return this.host;
    }

    public URI uri() {
        return this.uri;
    }

    public int port() {
        return this.port;
    }

    public String address() {
        return this.address;
    }

    public static DockerHost fromEnv() {
        String host = (String)Optional.fromNullable((Object)System.getenv("DOCKER_HOST")).or((Object)("localhost:" + DockerHost.defaultPort()));
        return new DockerHost(host);
    }

    public static DockerHost from(String endpoint) {
        return new DockerHost(endpoint);
    }

    private static int defaultPort() {
        String port = System.getenv("DOCKER_PORT");
        if (port == null) {
            return 2375;
        }
        try {
            return Integer.valueOf(port);
        }
        catch (NumberFormatException e) {
            return 2375;
        }
    }

    public String toString() {
        return this.host();
    }
}

