/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.readytalk.metrics.StatsDReporter;
import com.yammer.dropwizard.lifecycle.Managed;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ManagedStatsdReporter
implements Managed {
    private static final int POLL_INTERVAL_SECONDS = 15;
    private static final int SHUTDOWN_TIMEOUT_SECONDS = 5;
    private final StatsDReporter statsdReporter;

    public ManagedStatsdReporter(String endpoint, String name, MetricsRegistry registry) {
        if (Strings.isNullOrEmpty((String)endpoint)) {
            this.statsdReporter = null;
            return;
        }
        List parts = Splitter.on((String)":").splitToList((CharSequence)endpoint);
        Preconditions.checkArgument((parts.size() == 2 ? 1 : 0) != 0, (Object)"Specification of statsd host port has wrong number of parts. Should be host:port");
        String host = (String)parts.get(0);
        int port = Integer.valueOf((String)parts.get(1));
        this.statsdReporter = new StatsDReporter(registry, host, port, name);
    }

    public void start() throws Exception {
        if (this.statsdReporter != null) {
            this.statsdReporter.start(15L, TimeUnit.SECONDS);
        }
    }

    public void stop() throws Exception {
        if (this.statsdReporter != null) {
            this.statsdReporter.shutdown(5L, TimeUnit.SECONDS);
        }
    }
}

