/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.concurrent.TimeUnit;

public class MasterRequestMetrics {
    private final Counter successCounter;
    private final Counter failureCounter;
    private final Counter userErrorCounter;
    private final MetricName successMeterName;
    private final MetricName failureMeterName;
    private final MetricName userErrorMeterName;
    private final MetricName userErrorCounterName;
    private final MetricName failureCounterName;
    private final MetricName successCounterName;
    private final Meter successMeter;
    private final Meter failureMeter;
    private final Meter userErrorMeter;

    public MasterRequestMetrics(String group, String type, String requestName, MetricsRegistry registry) {
        this.successCounterName = new MetricName(group, type, requestName + "_count_success");
        this.failureCounterName = new MetricName(group, type, requestName + "_count_failures");
        this.userErrorCounterName = new MetricName(group, type, requestName + "_count_usererror");
        this.successMeterName = new MetricName(group, type, requestName + "_meter_success");
        this.failureMeterName = new MetricName(group, type, requestName + "_meter_failures");
        this.userErrorMeterName = new MetricName(group, type, requestName + "_meter_usererror");
        this.successCounter = registry.newCounter(this.successCounterName);
        this.failureCounter = registry.newCounter(this.failureCounterName);
        this.userErrorCounter = registry.newCounter(this.userErrorCounterName);
        this.successMeter = registry.newMeter(this.successMeterName, "successes", TimeUnit.SECONDS);
        this.failureMeter = registry.newMeter(this.failureMeterName, "failures", TimeUnit.SECONDS);
        this.userErrorMeter = registry.newMeter(this.userErrorMeterName, "user_errors", TimeUnit.SECONDS);
    }

    public void success() {
        this.successCounter.inc();
        this.successMeter.mark();
    }

    public void failure() {
        this.failureCounter.inc();
        this.failureMeter.mark();
    }

    public void userError() {
        this.userErrorCounter.inc();
        this.userErrorMeter.mark();
    }

    public Counter getSuccessCounter() {
        return this.successCounter;
    }

    public Counter getFailureCounter() {
        return this.failureCounter;
    }

    public Counter getUserErrorCounter() {
        return this.failureCounter;
    }

    public MetricName getSuccessName() {
        return this.successMeterName;
    }

    public MetricName getFailureName() {
        return this.failureMeterName;
    }

    public MetricName getUserErrorName() {
        return this.userErrorMeterName;
    }
}

