/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.spotify.helios.common.Json;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentAtomicReference<T> {
    private static final Logger log = LoggerFactory.getLogger(PersistentAtomicReference.class);
    private final Path filename;
    private final Path tempfilename;
    private final Object sync = new Object();
    private volatile T value;

    private PersistentAtomicReference(Path filename, JavaType javaType, Supplier<? extends T> initialValue) throws IOException, InterruptedException {
        try {
            byte[] bytes;
            this.filename = filename.toAbsolutePath();
            this.tempfilename = filename.getFileSystem().getPath(this.filename.toString() + ".tmp", new String[0]);
            this.value = Files.exists(filename, new LinkOption[0]) ? ((bytes = Files.readAllBytes(filename)).length > 0 ? Json.read((byte[])bytes, (JavaType)javaType) : initialValue.get()) : initialValue.get();
        }
        catch (InterruptedIOException | ClosedByInterruptException e) {
            throw new InterruptedException(e.getMessage());
        }
    }

    public void set(T newValue) throws IOException, InterruptedException {
        try {
            this.set0(newValue);
        }
        catch (InterruptedIOException | ClosedByInterruptException e) {
            throw new InterruptedException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set0(T newValue) throws IOException {
        log.debug("set: ({}) {}", (Object)this.filename, newValue);
        Object object = this.sync;
        synchronized (object) {
            String json = Json.asPrettyStringUnchecked(newValue);
            log.debug("write: ({}) {}", (Object)this.tempfilename, (Object)json);
            Files.write(this.tempfilename, json.getBytes(Charsets.UTF_8), new OpenOption[0]);
            log.debug("move: {} -> {}", (Object)this.tempfilename, (Object)this.filename);
            Files.move(this.tempfilename, this.filename, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            this.value = newValue;
        }
    }

    public void setUnchecked(T newValue) throws InterruptedException {
        try {
            this.set(newValue);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public T get() {
        return this.value;
    }

    public static <T> PersistentAtomicReference<T> create(Path filename, TypeReference<T> typeReference, Supplier<? extends T> initialValue) throws IOException, InterruptedException {
        return new PersistentAtomicReference<T>(filename, Json.type(typeReference), initialValue);
    }

    public static <T> PersistentAtomicReference<T> create(String filename, TypeReference<T> typeReference, Supplier<? extends T> initialValue) throws IOException, InterruptedException {
        return PersistentAtomicReference.create(FileSystems.getDefault().getPath(filename, new String[0]), typeReference, initialValue);
    }

    public static <T> PersistentAtomicReference<T> create(Path filename, JavaType javaType, Supplier<? extends T> initialValue) throws IOException, InterruptedException {
        return new PersistentAtomicReference<T>(filename, javaType, initialValue);
    }

    public static <T> PersistentAtomicReference<T> create(String filename, JavaType javaType, Supplier<? extends T> initialValue) throws IOException, InterruptedException {
        return PersistentAtomicReference.create(FileSystems.getDefault().getPath(filename, new String[0]), javaType, initialValue);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("filename", (Object)this.filename).toString();
    }
}

