/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.aphyr.riemann.client.AbstractRiemannClient;
import com.aphyr.riemann.client.EventDSL;

public class RiemannFacade {
    private static final Integer EVENT_TIME_TO_LIVE = 600;
    private final AbstractRiemannClient client;
    private final String hostName;
    private final String service;

    public RiemannFacade(AbstractRiemannClient client, String hostName, String service) {
        this.client = client;
        this.hostName = hostName;
        this.service = service;
    }

    public EventDSL event() {
        return this.client.event().time((double)System.currentTimeMillis() / 1000.0).ttl((float)EVENT_TIME_TO_LIVE.intValue()).host(this.hostName).service(this.service);
    }

    public RiemannFacade stack(String subService) {
        return new RiemannFacade(this.client, this.hostName, this.service + "/" + subService);
    }
}

