/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.google.common.util.concurrent.MoreExecutors;
import com.spotify.helios.servicescommon.RiemannFacade;
import com.yammer.dropwizard.lifecycle.Managed;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RiemannHeartBeat
implements Managed {
    private final ScheduledExecutorService scheduler = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(1), (long)0L, (TimeUnit)TimeUnit.SECONDS);
    private final int interval;
    private final TimeUnit timeUnit;
    private final RiemannFacade facade;

    public RiemannHeartBeat(TimeUnit timeUnit, int interval, RiemannFacade riemannFacade) {
        this.timeUnit = timeUnit;
        this.interval = interval;
        this.facade = riemannFacade.stack("heartbeat");
    }

    public void start() throws Exception {
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                RiemannHeartBeat.this.facade.event().state("ok").metric(1.0).tags(new String[]{"heartbeat"}).ttl((float)RiemannHeartBeat.this.timeUnit.toSeconds(RiemannHeartBeat.this.interval * 3)).send();
            }
        }, 0L, this.interval, this.timeUnit);
    }

    public void stop() throws Exception {
        this.scheduler.shutdownNow();
    }
}

