/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.AbstractIdleService;
import com.spotify.helios.common.LoggingConfig;
import com.spotify.logging.LoggingConfigurator;
import java.io.File;
import java.util.Arrays;
import org.slf4j.bridge.SLF4JBridgeHandler;

public abstract class ServiceMain
extends AbstractIdleService {
    protected ServiceMain(LoggingConfig loggingConfig, String sentryDsn) {
        ServiceMain.setupLogging(loggingConfig, sentryDsn);
    }

    protected static void setupLogging(LoggingConfig config, String sentryDsn) {
        if (config.getNoLogSetup()) {
            return;
        }
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        int verbose = config.getVerbosity();
        LoggingConfigurator.Level level = (LoggingConfigurator.Level)Iterables.get(Arrays.asList(LoggingConfigurator.Level.INFO, LoggingConfigurator.Level.DEBUG, LoggingConfigurator.Level.ALL), (int)verbose, (Object)LoggingConfigurator.Level.ALL);
        File logconfig = config.getConfigFile();
        if (logconfig != null) {
            LoggingConfigurator.configure((File)logconfig);
        } else {
            if (config.isSyslog()) {
                LoggingConfigurator.configureSyslogDefaults((String)"helios", (LoggingConfigurator.Level)level);
            } else {
                LoggingConfigurator.configureDefaults((String)"helios", (LoggingConfigurator.Level)level);
            }
            if (!Strings.isNullOrEmpty((String)sentryDsn)) {
                LoggingConfigurator.addSentryAppender((String)sentryDsn);
            }
        }
    }
}

