/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon;

import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.spotify.helios.agent.BoundedRandomExponentialBackoff;
import com.spotify.helios.agent.RetryIntervalPolicy;
import com.spotify.helios.agent.RetryScheduler;
import com.spotify.helios.servicescommon.DefaultReactor;
import com.spotify.helios.servicescommon.Reactor;
import com.spotify.helios.servicescommon.ZooKeeperRegistrarEventListener;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperRegistrar
extends AbstractIdleService {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperRegistrar.class);
    private final ZooKeeperClient client;
    private final Reactor reactor;
    private final ZooKeeperRegistrarEventListener eventListener;
    private final RetryIntervalPolicy retryIntervalPolicy;
    private ConnectionStateListener listener = new ConnectionStateListener(){

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState == ConnectionState.RECONNECTED) {
                ZooKeeperRegistrar.this.reactor.signal();
            }
        }
    };

    public ZooKeeperRegistrar(ZooKeeperClient client, ZooKeeperRegistrarEventListener eventListener) {
        this(client, eventListener, BoundedRandomExponentialBackoff.newBuilder().setMinInterval(1L, TimeUnit.SECONDS).setMaxInterval(30L, TimeUnit.SECONDS).build());
    }

    public ZooKeeperRegistrar(ZooKeeperClient client, ZooKeeperRegistrarEventListener eventListener, RetryIntervalPolicy retryIntervalPolicy) {
        this.client = client;
        this.eventListener = eventListener;
        this.retryIntervalPolicy = retryIntervalPolicy;
        this.reactor = new DefaultReactor("zk-client-async-init", new Update());
    }

    protected void startUp() throws Exception {
        this.eventListener.startUp();
        this.client.getConnectionStateListenable().addListener((Object)this.listener);
        this.reactor.startAsync().awaitRunning();
        this.reactor.signal();
    }

    protected void shutDown() throws Exception {
        this.reactor.stopAsync().awaitTerminated();
        this.eventListener.shutDown();
    }

    private boolean isAlive() {
        return this.state().ordinal() < Service.State.STOPPING.ordinal();
    }

    private class Update
    implements Reactor.Callback {
        private Update() {
        }

        @Override
        public void run(boolean timeout) throws InterruptedException {
            RetryScheduler retryScheduler = ZooKeeperRegistrar.this.retryIntervalPolicy.newScheduler();
            while (ZooKeeperRegistrar.this.isAlive()) {
                try {
                    ZooKeeperRegistrar.this.eventListener.tryToRegister(ZooKeeperRegistrar.this.client);
                    return;
                }
                catch (KeeperException e) {
                    long sleep = retryScheduler.nextMillis();
                    if (e instanceof KeeperException.ConnectionLossException) {
                        log.warn("ZooKeeper connection lost, retrying registration in {} ms", (Object)sleep);
                    } else {
                        log.error("ZooKeeper registration failed, retrying in {} ms", (Object)sleep, (Object)e);
                    }
                    Thread.sleep(sleep);
                }
            }
        }
    }
}

