/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.coordination;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.spotify.helios.servicescommon.coordination.Node;
import com.spotify.helios.servicescommon.coordination.PersistentPathChildrenCache;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.ZooKeeperOperation;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.api.transaction.CuratorTransactionFinal;
import org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.framework.recipes.nodes.PersistentEphemeralNode;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.utils.EnsurePath;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultZooKeeperClient
implements ZooKeeperClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultZooKeeperClient.class);
    private final CuratorFramework client;

    public DefaultZooKeeperClient(CuratorFramework client) {
        this.client = client;
    }

    @Override
    public CuratorFramework getCuratorFramework() {
        return this.client;
    }

    @Override
    public void ensurePath(String path) throws KeeperException {
        this.ensurePath(path, false);
    }

    @Override
    public void ensurePath(String path, boolean excludingLast) throws KeeperException {
        EnsurePath ensurePath = new EnsurePath(path);
        if (excludingLast) {
            ensurePath = ensurePath.excludingLast();
        }
        try {
            ensurePath.ensure(this.client.getZookeeperClient());
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public byte[] getData(String path) throws KeeperException {
        try {
            return (byte[])this.client.getData().forPath(path);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Node getNode(String path) throws KeeperException {
        Stat stat = new Stat();
        try {
            byte[] bytes = (byte[])((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(path);
            return new Node(path, bytes, stat);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Stat exists(String path) throws KeeperException {
        try {
            return (Stat)this.client.checkExists().forPath(path);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void start() {
        this.client.start();
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public PersistentEphemeralNode persistentEphemeralNode(String path, PersistentEphemeralNode.Mode mode, byte[] data) {
        return new PersistentEphemeralNode(this.client, mode, path, data);
    }

    @Override
    public Listenable<ConnectionStateListener> getConnectionStateListenable() {
        return this.client.getConnectionStateListenable();
    }

    @Override
    public ZooKeeper.States getState() throws KeeperException {
        try {
            return this.client.getZookeeperClient().getZooKeeper().getState();
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public List<String> getChildren(String path) throws KeeperException {
        try {
            return (List)this.client.getChildren().forPath(path);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void deleteRecursive(String path) throws KeeperException {
        try {
            List<String> nodes = this.listRecursive(path);
            if (nodes.isEmpty()) {
                return;
            }
            CuratorTransactionFinal t = ((CuratorTransactionBridge)this.client.inTransaction().check().forPath(path)).and();
            for (String node : Lists.reverse(nodes)) {
                ((CuratorTransactionBridge)t.delete().forPath(node)).and();
            }
            t.commit();
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public List<String> listRecursive(String path) throws KeeperException {
        try {
            return ZKUtil.listSubTreeBFS((ZooKeeper)this.client.getZookeeperClient().getZooKeeper(), (String)path);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void delete(String path) throws KeeperException {
        try {
            this.client.delete().forPath(path);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void delete(String path, int version) throws KeeperException {
        try {
            this.client.getZookeeperClient().getZooKeeper().delete(path, version);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void createAndSetData(String path, byte[] data) throws KeeperException {
        try {
            this.client.create().forPath(path, data);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void create(String path) throws KeeperException {
        try {
            this.client.create().forPath(path);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void createWithMode(String path, CreateMode mode) throws KeeperException {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().withMode(mode)).forPath(path);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void setData(String path, byte[] data) throws KeeperException {
        try {
            this.client.setData().forPath(path, data);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Stat stat(String path) throws KeeperException {
        try {
            return (Stat)this.client.checkExists().forPath(path);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public <T> PersistentPathChildrenCache<T> pathChildrenCache(String path, Path snapshotFile, JavaType valueType) throws IOException, InterruptedException {
        return new PersistentPathChildrenCache(this.client, path, snapshotFile, valueType);
    }

    @Override
    public Collection<CuratorTransactionResult> transaction(List<ZooKeeperOperation> operations) throws KeeperException {
        log.debug("transaction: {}", operations);
        if (operations.isEmpty()) {
            return Collections.emptyList();
        }
        CuratorTransactionFinal transaction = (CuratorTransactionFinal)this.client.inTransaction();
        for (ZooKeeperOperation operation : operations) {
            try {
                operation.register((CuratorTransaction)transaction);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        try {
            return transaction.commit();
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, KeeperException.class);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Collection<CuratorTransactionResult> transaction(ZooKeeperOperation ... operations) throws KeeperException {
        return this.transaction(Arrays.asList(operations));
    }
}

