/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.coordination;

import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.servicescommon.coordination.PathFactory;
import java.util.UUID;

public class Paths {
    private static final String UP = "up";
    private static final String CONFIG = "config";
    private static final String STATUS = "status";
    private static final String JOBS = "jobs";
    private static final String JOBREFS = "jobrefs";
    private static final String HOSTS = "hosts";
    private static final String EVENTS = "events";
    private static final String MASTERS = "masters";
    private static final String HISTORY = "history";
    private static final String HOSTINFO = "hostinfo";
    private static final String AGENTINFO = "agentinfo";
    private static final String PORTS = "ports";
    private static final String ENVIRONMENT = "environment";
    private static final String ID = "id";
    private static final PathFactory CONFIG_JOBS = new PathFactory("/", "config", "jobs");
    private static final PathFactory CONFIG_JOBREFS = new PathFactory("/", "config", "jobrefs");
    private static final PathFactory CONFIG_HOSTS = new PathFactory("/", "config", "hosts");
    private static final PathFactory STATUS_HOSTS = new PathFactory("/", "status", "hosts");
    private static final PathFactory STATUS_MASTERS = new PathFactory("/", "status", "masters");
    private static final PathFactory HISTORY_JOBS = new PathFactory("/", "history", "jobs");
    private static final String CREATION_PREFIX = "creation-";

    public static String configHosts() {
        return CONFIG_HOSTS.path(new String[0]);
    }

    public static String configJobs() {
        return CONFIG_JOBS.path(new String[0]);
    }

    public static String configJobRefs() {
        return CONFIG_JOBREFS.path(new String[0]);
    }

    public static String configJob(JobId id) {
        return CONFIG_JOBS.path(id.toString());
    }

    public static boolean isConfigJobCreation(JobId id, String parent, String child) {
        return child.startsWith(CREATION_PREFIX);
    }

    public static UUID configJobCreationId(JobId id, String parent, String child) {
        return UUID.fromString(child.substring(CREATION_PREFIX.length()));
    }

    public static String configHostJobCreationParent(JobId id) {
        return Paths.configJob(id);
    }

    public static String configJobCreation(JobId id, UUID operationId) {
        String name = CREATION_PREFIX + operationId;
        return CONFIG_JOBS.path(id.toString(), name);
    }

    public static String configJobRefShort(JobId id) {
        return CONFIG_JOBREFS.path(id.getName() + ":" + id.getVersion());
    }

    public static String configJobHosts(JobId jobId) {
        return CONFIG_JOBS.path(jobId.toString(), HOSTS);
    }

    public static String configJobHost(JobId jobId, String host) {
        return CONFIG_JOBS.path(jobId.toString(), HOSTS, host);
    }

    public static String configHost(String host) {
        return CONFIG_HOSTS.path(host);
    }

    public static String configHostId(String host) {
        return CONFIG_HOSTS.path(host, ID);
    }

    public static String configHostJobs(String host) {
        return CONFIG_HOSTS.path(host, JOBS);
    }

    public static String configHostJob(String host, JobId jobId) {
        return CONFIG_HOSTS.path(host, JOBS, jobId.toString());
    }

    public static String configHostJobCreation(String host, JobId id, UUID operationId) {
        return CONFIG_HOSTS.path(host, JOBS, id.toString(), CREATION_PREFIX + operationId);
    }

    public static String configHostPorts(String host) {
        return CONFIG_HOSTS.path(host, PORTS);
    }

    public static String configHostPort(String host, int port) {
        return CONFIG_HOSTS.path(host, PORTS, String.valueOf(port));
    }

    public static String statusHosts() {
        return STATUS_HOSTS.path(new String[0]);
    }

    public static String statusHost(String host) {
        return STATUS_HOSTS.path(host);
    }

    public static String statusHostJobs(String host) {
        return STATUS_HOSTS.path(host, JOBS);
    }

    public static String statusHostJob(String host, JobId jobId) {
        return STATUS_HOSTS.path(host, JOBS, jobId.toString());
    }

    public static String statusHostUp(String host) {
        return STATUS_HOSTS.path(host, UP);
    }

    public static String statusMasterUp(String master) {
        return STATUS_MASTERS.path(master, UP);
    }

    public static String statusMasters() {
        return STATUS_MASTERS.path(new String[0]);
    }

    public static String statusMaster() {
        return STATUS_MASTERS.path(new String[0]);
    }

    public static String statusHostInfo(String host) {
        return STATUS_HOSTS.path(host, HOSTINFO);
    }

    public static String statusHostAgentInfo(String host) {
        return STATUS_HOSTS.path(host, AGENTINFO);
    }

    public static String statusHostEnvVars(String host) {
        return STATUS_HOSTS.path(host, ENVIRONMENT);
    }

    public static String historyJobHostEventsTimestamp(JobId jobId, String host, long timestamp) {
        return HISTORY_JOBS.path(jobId.toString(), HOSTS, host, EVENTS, String.valueOf(timestamp));
    }

    public static String historyJobHostEvents(JobId jobId, String host) {
        return HISTORY_JOBS.path(jobId.toString(), HOSTS, host, EVENTS);
    }

    public static String historyJobHosts(JobId jobId) {
        return HISTORY_JOBS.path(jobId.toString(), HOSTS);
    }

    public static String historyJobHost(JobId jobId, String host) {
        return HISTORY_JOBS.path(jobId.toString(), HOSTS, host);
    }

    public static String historyJob(JobId jobId) {
        return HISTORY_JOBS.path(jobId.toString());
    }

    public static String historyJobs() {
        return HISTORY_JOBS.path(new String[0]);
    }
}

