/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.coordination;

import com.fasterxml.jackson.databind.JavaType;
import com.spotify.helios.servicescommon.coordination.Node;
import com.spotify.helios.servicescommon.coordination.PersistentPathChildrenCache;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.ZooKeeperModelReporter;
import com.spotify.helios.servicescommon.coordination.ZooKeeperOperation;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.framework.recipes.nodes.PersistentEphemeralNode;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ReportingZooKeeperClient
implements ZooKeeperClient {
    private final ZooKeeperClient client;
    private final String tag;
    private final ZooKeeperModelReporter reporter;

    public ReportingZooKeeperClient(ZooKeeperClient client, ZooKeeperModelReporter reporter, String tag) {
        this.client = client;
        this.tag = tag;
        this.reporter = reporter;
    }

    @Override
    public void ensurePath(String path) throws KeeperException {
        try {
            this.client.ensurePath(path);
        }
        catch (KeeperException e) {
            this.reporter.checkException((Exception)((Object)e), this.tag, "ensurePath");
            throw e;
        }
    }

    @Override
    public void ensurePath(String path, boolean excludingLast) throws KeeperException {
        try {
            this.client.ensurePath(path, excludingLast);
        }
        catch (KeeperException e) {
            this.reporter.checkException((Exception)((Object)e), this.tag, "ensurePath");
            throw e;
        }
    }

    @Override
    public byte[] getData(String path) throws KeeperException {
        try {
            return this.client.getData(path);
        }
        catch (KeeperException e) {
            this.reporter.checkException((Exception)((Object)e), this.tag, "getData");
            throw e;
        }
    }

    @Override
    public List<String> getChildren(String path) throws KeeperException {
        try {
            return this.client.getChildren(path);
        }
        catch (KeeperException e) {
            this.reporter.checkException((Exception)((Object)e), this.tag, "getChildren");
            throw e;
        }
    }

    @Override
    public void delete(String path) throws KeeperException {
        try {
            this.client.delete(path);
        }
        catch (KeeperException e) {
            this.reporter.checkException((Exception)((Object)e), this.tag, "delete");
            throw e;
        }
    }

    @Override
    public void setData(String path, byte[] bytes) throws KeeperException {
        try {
            this.client.setData(path, bytes);
        }
        catch (KeeperException e) {
            this.reporter.checkException((Exception)((Object)e), this.tag, "setData");
            throw e;
        }
    }

    @Override
    public void createAndSetData(String path, byte[] data) throws KeeperException {
        try {
            this.client.createAndSetData(path, data);
        }
        catch (KeeperException e) {
            this.reporter.checkException((Exception)((Object)e), this.tag, "createAndSetData");
            throw e;
        }
    }

    @Override
    public void createWithMode(String path, CreateMode mode) throws KeeperException {
        try {
            this.client.createWithMode(path, mode);
        }
        catch (KeeperException e) {
            this.reporter.checkException((Exception)((Object)e), this.tag, "createWithMode");
            throw e;
        }
    }

    @Override
    public Stat stat(String path) throws KeeperException {
        try {
            return this.client.stat(path);
        }
        catch (KeeperException e) {
            this.reporter.checkException((Exception)((Object)e), this.tag, "stat");
            throw e;
        }
    }

    @Override
    public void deleteRecursive(String path) throws KeeperException {
        try {
            this.client.deleteRecursive(path);
        }
        catch (KeeperException e) {
            this.reporter.checkException((Exception)((Object)e), this.tag, "deleteRecursive");
            throw e;
        }
    }

    @Override
    public List<String> listRecursive(String path) throws KeeperException {
        try {
            return this.client.listRecursive(path);
        }
        catch (KeeperException e) {
            this.reporter.checkException((Exception)((Object)e), this.tag, "listRecursive");
            throw e;
        }
    }

    @Override
    public void create(String path) throws KeeperException {
        try {
            this.client.create(path);
        }
        catch (KeeperException e) {
            this.reporter.checkException((Exception)((Object)e), this.tag, "create");
            throw e;
        }
    }

    @Override
    public <T> PersistentPathChildrenCache<T> pathChildrenCache(String path, Path snapshotFile, JavaType valueType) throws IOException, InterruptedException {
        return this.client.pathChildrenCache(path, snapshotFile, valueType);
    }

    @Override
    public Collection<CuratorTransactionResult> transaction(List<ZooKeeperOperation> operations) throws KeeperException {
        try {
            return this.client.transaction(operations);
        }
        catch (KeeperException e) {
            this.reporter.checkException((Exception)((Object)e), this.tag, "transaction");
            throw e;
        }
    }

    @Override
    public Collection<CuratorTransactionResult> transaction(ZooKeeperOperation ... operations) throws KeeperException {
        try {
            return this.client.transaction(operations);
        }
        catch (KeeperException e) {
            this.reporter.checkException((Exception)((Object)e), this.tag, "transaction");
            throw e;
        }
    }

    @Override
    public void delete(String path, int version) throws KeeperException {
        try {
            this.client.delete(path, version);
        }
        catch (KeeperException e) {
            this.reporter.checkException((Exception)((Object)e), this.tag, "delete");
            throw e;
        }
    }

    @Override
    public Node getNode(String path) throws KeeperException {
        try {
            return this.client.getNode(path);
        }
        catch (KeeperException e) {
            this.reporter.checkException((Exception)((Object)e), this.tag, "getNode");
            throw e;
        }
    }

    @Override
    public Stat exists(String path) throws KeeperException {
        try {
            return this.client.exists(path);
        }
        catch (KeeperException e) {
            this.reporter.checkException((Exception)((Object)e), this.tag, "exists");
            throw e;
        }
    }

    @Override
    public Listenable<ConnectionStateListener> getConnectionStateListenable() {
        return this.client.getConnectionStateListenable();
    }

    @Override
    public ZooKeeper.States getState() throws KeeperException {
        try {
            return this.client.getState();
        }
        catch (KeeperException e) {
            this.reporter.checkException((Exception)((Object)e), this.tag, "getState");
            throw e;
        }
    }

    @Override
    public PersistentEphemeralNode persistentEphemeralNode(String path, PersistentEphemeralNode.Mode mode, byte[] data) {
        return this.client.persistentEphemeralNode(path, mode, data);
    }

    @Override
    public void start() {
        this.client.start();
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public CuratorFramework getCuratorFramework() {
        return this.client.getCuratorFramework();
    }
}

