/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.coordination;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.helios.servicescommon.DefaultReactor;
import com.spotify.helios.servicescommon.Reactor;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import java.util.Map;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryingZooKeeperNodeWriter
extends AbstractIdleService {
    private static final Logger log = LoggerFactory.getLogger(RetryingZooKeeperNodeWriter.class);
    private static final long RETRY_INTERVAL_MILLIS = 5000L;
    private final ZooKeeperClient client;
    private final Reactor reactor;
    private final Map<String, Write> front = Maps.newHashMap();
    private final Map<String, Write> back = Maps.newHashMap();
    private final Object lock = new Object(){};

    public RetryingZooKeeperNodeWriter(String name, ZooKeeperClient client) {
        this.client = client;
        this.reactor = new DefaultReactor(name, new Update(), 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> set(String path, byte[] data) {
        Write prev;
        Write write = new Write(data);
        Object object = this.lock;
        synchronized (object) {
            prev = this.front.put(path, write);
        }
        this.reactor.signal();
        if (prev != null) {
            prev.cancel(false);
        }
        return write;
    }

    protected void startUp() throws Exception {
        this.reactor.startAsync().awaitRunning();
    }

    protected void shutDown() throws Exception {
        this.reactor.stopAsync().awaitTerminated();
    }

    private static class Write
    extends AbstractFuture<Void> {
        final byte[] data;

        private Write(byte[] data) {
            this.data = data;
        }

        public void done() {
            this.set(null);
        }
    }

    private class Update
    implements Reactor.Callback {
        private Update() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(boolean timeout) {
            if (RetryingZooKeeperNodeWriter.this.front.isEmpty() && RetryingZooKeeperNodeWriter.this.back.isEmpty()) {
                return;
            }
            Object object = RetryingZooKeeperNodeWriter.this.lock;
            synchronized (object) {
                for (Map.Entry entry : RetryingZooKeeperNodeWriter.this.front.entrySet()) {
                    Write prev = (Write)((Object)RetryingZooKeeperNodeWriter.this.back.put(entry.getKey(), entry.getValue()));
                    if (prev == null) continue;
                    prev.cancel(false);
                }
                RetryingZooKeeperNodeWriter.this.front.clear();
            }
            log.debug("writing: {}", RetryingZooKeeperNodeWriter.this.back.keySet());
            for (Map.Entry entry : ImmutableMap.copyOf((Map)RetryingZooKeeperNodeWriter.this.back).entrySet()) {
                String path = (String)entry.getKey();
                Write write = (Write)((Object)entry.getValue());
                try {
                    if (RetryingZooKeeperNodeWriter.this.client.stat(path) == null) {
                        RetryingZooKeeperNodeWriter.this.client.createAndSetData(path, write.data);
                    } else {
                        RetryingZooKeeperNodeWriter.this.client.setData(path, write.data);
                    }
                    RetryingZooKeeperNodeWriter.this.back.remove(path);
                    write.done();
                }
                catch (KeeperException e) {
                    log.error("Failed writing node: {}", (Object)path, (Object)e);
                }
            }
        }
    }
}

