/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.coordination;

import com.spotify.helios.servicescommon.RiemannFacade;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import com.yammer.dropwizard.lifecycle.Managed;
import com.yammer.metrics.core.HealthCheck;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;

public class ZooKeeperHealthChecker
extends HealthCheck
implements Managed,
PathChildrenCacheListener,
Runnable {
    private static final String UNKNOWN = "UNKNOWN";
    private final ScheduledExecutorService scheduler;
    private final PathChildrenCache cache;
    private final RiemannFacade facade;
    private final TimeUnit timeUnit;
    private final long interval;
    private AtomicReference<String> reasonString = new AtomicReference<String>("UNKNOWN");

    public ZooKeeperHealthChecker(ZooKeeperClient zooKeeperClient, String path, RiemannFacade facade, TimeUnit timeUnit, long interval) {
        super("zookeeper");
        this.scheduler = Executors.newScheduledThreadPool(2);
        this.cache = new PathChildrenCache(zooKeeperClient.getCuratorFramework(), path, true, false, (ExecutorService)this.scheduler);
        this.facade = facade.stack("zookeeper-connection");
        this.timeUnit = timeUnit;
        this.interval = interval;
        this.cache.getListenable().addListener((Object)this);
    }

    @Override
    public void run() {
        String reason = this.reasonString.get();
        if (UNKNOWN.equals(this.reasonString.get())) {
            return;
        }
        if (reason != null) {
            this.facade.event().state("critical").metric(0.0).ttl((float)this.timeUnit.toSeconds(this.interval * 3L)).tags(new String[]{"zookeeper", "connection"}).description(reason).send();
        } else {
            this.facade.event().state("ok").metric(1.0).tags(new String[]{"zookeeper", "connection"}).ttl((float)this.timeUnit.toSeconds(this.interval * 3L)).send();
        }
    }

    private void setState(String newState) {
        if (this.reasonString.get() == null != (newState == null)) {
            this.reasonString.set(newState);
            this.run();
        }
    }

    public void childEvent(CuratorFramework curator, PathChildrenCacheEvent event) throws Exception {
        switch (event.getType()) {
            case INITIALIZED: 
            case CONNECTION_RECONNECTED: 
            case CHILD_ADDED: 
            case CHILD_REMOVED: 
            case CHILD_UPDATED: {
                this.setState(null);
                break;
            }
            case CONNECTION_LOST: {
                this.setState("CONNECTION_LOST");
                break;
            }
            case CONNECTION_SUSPENDED: {
                this.setState("CONNECTION_SUSPENDED");
            }
        }
    }

    public void start() throws Exception {
        this.cache.start();
        this.scheduler.scheduleAtFixedRate(this, 0L, this.interval, this.timeUnit);
    }

    public void stop() throws Exception {
        this.scheduler.shutdownNow();
    }

    protected HealthCheck.Result check() throws Exception {
        if (this.reasonString.get() == null) {
            return HealthCheck.Result.healthy();
        }
        return HealthCheck.Result.unhealthy((String)this.reasonString.get());
    }
}

