/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.coordination;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AbstractIdleService;
import com.spotify.helios.servicescommon.DefaultReactor;
import com.spotify.helios.servicescommon.PersistentAtomicReference;
import com.spotify.helios.servicescommon.Reactor;
import com.spotify.helios.servicescommon.coordination.Node;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClientProvider;
import com.spotify.helios.servicescommon.coordination.ZooKeeperOperations;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperPersistentNodeRemover
extends AbstractIdleService {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperPersistentNodeRemover.class);
    private static final boolean DEFAULT_RECURSIVE = false;
    private static final long RETRY_INTERVAL_MILLIS = 5000L;
    public static final TypeReference<List<String>> PATHS_TYPE = new TypeReference<List<String>>(){};
    private static final List<String> EMPTY_PATHS = Collections.emptyList();
    private final ZooKeeperClientProvider provider;
    private final Reactor reactor;
    private final PersistentAtomicReference<List<String>> front;
    private final PersistentAtomicReference<List<String>> back;
    private final Predicate<Node> predicate;
    private final boolean recursive;
    private final Object lock = new Object(){};

    public ZooKeeperPersistentNodeRemover(String name, ZooKeeperClientProvider provider, Path stateFile, Predicate<Node> predicate) throws IOException, InterruptedException {
        this(name, provider, stateFile, predicate, false);
    }

    public ZooKeeperPersistentNodeRemover(String name, ZooKeeperClientProvider provider, Path stateFile, Predicate<Node> predicate, boolean recursive) throws IOException, InterruptedException {
        this.provider = provider;
        this.predicate = predicate;
        this.front = PersistentAtomicReference.create(stateFile.toString() + ".front", PATHS_TYPE, Suppliers.ofInstance(EMPTY_PATHS));
        this.back = PersistentAtomicReference.create(stateFile.toString() + ".back", PATHS_TYPE, Suppliers.ofInstance(EMPTY_PATHS));
        this.reactor = new DefaultReactor(name, new Update(), 5000L);
        this.recursive = recursive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String path) throws InterruptedException {
        while (true) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    HashSet mutable = Sets.newHashSet((Iterable)this.front.get());
                    mutable.add(path);
                    this.front.set((List<String>)ImmutableList.copyOf((Collection)mutable));
                }
            }
            catch (IOException e) {
                log.error("Error updating front", (Throwable)e);
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
        this.reactor.signal();
    }

    public static ZooKeeperPersistentNodeRemover create(String name, ZooKeeperClientProvider provider, Path stateFile, Predicate<Node> predicate) throws IOException, InterruptedException {
        return new ZooKeeperPersistentNodeRemover(name, provider, stateFile, predicate);
    }

    public static ZooKeeperPersistentNodeRemover create(String name, ZooKeeperClientProvider provider, Path stateFile, Predicate<Node> predicate, boolean recursive) throws IOException, InterruptedException {
        return new ZooKeeperPersistentNodeRemover(name, provider, stateFile, predicate, recursive);
    }

    protected void startUp() throws Exception {
        this.reactor.startAsync().awaitRunning();
    }

    protected void shutDown() throws Exception {
        this.reactor.stopAsync().awaitTerminated();
    }

    private boolean evaluate(Node node) {
        return this.predicate.apply((Object)node);
    }

    private class Update
    implements Reactor.Callback {
        private Update() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(boolean timeout) throws InterruptedException {
            HashSet backPaths = Sets.newHashSet((Iterable)((Iterable)ZooKeeperPersistentNodeRemover.this.back.get()));
            Object object = ZooKeeperPersistentNodeRemover.this.lock;
            synchronized (object) {
                if (!((List)ZooKeeperPersistentNodeRemover.this.front.get()).isEmpty()) {
                    List frontPaths = (List)ZooKeeperPersistentNodeRemover.this.front.get();
                    backPaths.addAll(frontPaths);
                    try {
                        ZooKeeperPersistentNodeRemover.this.back.set(ImmutableList.copyOf((Collection)backPaths));
                        ZooKeeperPersistentNodeRemover.this.front.set(EMPTY_PATHS);
                    }
                    catch (IOException e) {
                        log.error("Error draining front", (Throwable)e);
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            }
            HashSet newBackPaths = Sets.newHashSet((Iterable)backPaths);
            ZooKeeperClient client = ZooKeeperPersistentNodeRemover.this.provider.get("persistent_remover");
            for (String path : backPaths) {
                Node node = null;
                try {
                    node = client.getNode(path);
                }
                catch (KeeperException.NoNodeException ignore) {
                    newBackPaths.remove(path);
                }
                catch (KeeperException.ConnectionLossException e) {
                    log.warn("ZooKeeper connection lost while inspecting node: {}", (Object)path);
                    throw Throwables.propagate((Throwable)e);
                }
                catch (KeeperException e) {
                    log.error("Failed inspecting node: {}", (Object)path);
                }
                if (node == null) continue;
                try {
                    boolean remove;
                    try {
                        remove = ZooKeeperPersistentNodeRemover.this.evaluate(node);
                    }
                    catch (Exception e) {
                        log.error("Condition threw exception for node: {}", (Object)e, (Object)path);
                        continue;
                    }
                    if (!remove) continue;
                    ArrayList nodes = Lists.newArrayList();
                    if (ZooKeeperPersistentNodeRemover.this.recursive) {
                        nodes.addAll(Lists.reverse(client.listRecursive(path)));
                    } else {
                        nodes.add(path);
                    }
                    client.transaction(ZooKeeperOperations.check(path, node.getStat().getVersion()), ZooKeeperOperations.delete(nodes));
                    newBackPaths.remove(path);
                    log.debug("Removed node: {}", (Object)path);
                }
                catch (KeeperException.BadVersionException | KeeperException.NoNodeException ignore) {
                    newBackPaths.remove(path);
                }
                catch (KeeperException.ConnectionLossException e) {
                    log.warn("ZooKeeper connection lost while removing node: {}", (Object)path);
                    throw Throwables.propagate((Throwable)e);
                }
                catch (KeeperException e) {
                    log.error("Failed removing node: {}", (Object)path, (Object)e);
                }
            }
            try {
                ImmutableList newBackPathsList = ImmutableList.copyOf((Collection)newBackPaths);
                if (!((List)ZooKeeperPersistentNodeRemover.this.back.get()).equals(newBackPathsList)) {
                    ZooKeeperPersistentNodeRemover.this.back.set(newBackPathsList);
                }
            }
            catch (IOException e) {
                log.error("Error writing back", (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

