/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.statistics;

import com.google.common.collect.Maps;
import com.spotify.helios.servicescommon.MasterRequestMetrics;
import com.spotify.helios.servicescommon.statistics.MasterMetrics;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Map;

public class MasterMetricsImpl
implements MasterMetrics {
    private static final String TYPE = "master";
    private final Map<String, MasterRequestMetrics> requestMetrics = Maps.newConcurrentMap();
    private final MetricName jobsInJobList;
    private final MetricName eventsInJobHistory;
    private final Histogram jobsInJobListHist;
    private final Histogram eventsInJobHistoryHist;
    private final String group;
    private final MetricsRegistry registry;

    public MasterMetricsImpl(String group, MetricsRegistry registry) {
        this.group = group;
        this.registry = registry;
        this.eventsInJobHistory = new MetricName(group, TYPE, "events_in_job_history");
        this.jobsInJobList = new MetricName(group, TYPE, "jobs_in_job_list");
        this.eventsInJobHistoryHist = registry.newHistogram(this.eventsInJobHistory, true);
        this.jobsInJobListHist = registry.newHistogram(this.jobsInJobList, true);
    }

    @Override
    public void success(String name) {
        this.request(name).success();
    }

    @Override
    public void failure(String name) {
        this.request(name).failure();
    }

    @Override
    public void badRequest(String name) {
        this.request(name).userError();
    }

    private MasterRequestMetrics request(String name) {
        MasterRequestMetrics m = this.requestMetrics.get(name);
        if (m == null) {
            m = new MasterRequestMetrics(this.group, TYPE, name, this.registry);
            this.requestMetrics.put(name, m);
        }
        return m;
    }

    @Override
    public void jobsInJobList(int count) {
        this.jobsInJobListHist.update(count);
    }

    @Override
    public void jobsHistoryEventSize(int count) {
        this.eventsInJobHistoryHist.update(count);
    }
}

