/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.statistics;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.util.concurrent.TimeUnit;

public class RequestMetrics {
    private final Counter successCounter;
    private final Counter failureCounter;
    private final Counter userErrorCounter;
    private final Timer timer;
    private final MetricName successName;
    private final MetricName failureName;
    private final MetricName userErrorName;
    private final MetricName timerName;

    public RequestMetrics(String group, String type, String requestName, MetricsRegistry registry) {
        this.successName = new MetricName(group, type, requestName + "_successful");
        this.failureName = new MetricName(group, type, requestName + "_failed");
        this.userErrorName = new MetricName(group, type, requestName + "_failed");
        this.timerName = new MetricName(group, type, requestName + "_latency");
        this.successCounter = registry.newCounter(this.successName);
        this.failureCounter = registry.newCounter(this.failureName);
        this.userErrorCounter = registry.newCounter(this.userErrorName);
        this.timer = registry.newTimer(this.timerName, TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
    }

    public TimerContext begin() {
        return this.timer.time();
    }

    public void success(TimerContext context) {
        this.success();
        context.stop();
    }

    public void success() {
        this.successCounter.inc();
    }

    public void failure(TimerContext context) {
        this.failure();
        context.stop();
    }

    public void failure() {
        this.failureCounter.inc();
    }

    public void userError(TimerContext context) {
        this.userError();
        context.stop();
    }

    public void userError() {
        this.userErrorCounter.inc();
    }

    public Counter getSuccessCounter() {
        return this.successCounter;
    }

    public Counter getFailureCounter() {
        return this.failureCounter;
    }

    public Counter getUserErrorCounter() {
        return this.failureCounter;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public MetricName getSuccessName() {
        return this.successName;
    }

    public MetricName getFailureName() {
        return this.failureName;
    }

    public MetricName getTimerName() {
        return this.timerName;
    }

    public MetricName getUserErrorName() {
        return this.userErrorName;
    }
}

