/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.servicescommon.statistics;

import com.spotify.helios.servicescommon.statistics.MeterRates;
import com.spotify.helios.servicescommon.statistics.MetricsContext;
import com.spotify.helios.servicescommon.statistics.MetricsContextImpl;
import com.spotify.helios.servicescommon.statistics.RequestMetrics;
import com.spotify.helios.servicescommon.statistics.SupervisorMetrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.concurrent.TimeUnit;

public class SupervisorMetricsImpl
implements SupervisorMetrics {
    private static final String TYPE = "agent_supervisor";
    private final RequestMetrics imagePull;
    private final Counter containerStartedCounter;
    private final Counter containersExitedCounter;
    private final Counter containersRunningCounter;
    private final Counter containersThrewExceptionCounter;
    private final Counter imageCacheHitCounter;
    private final Counter supervisorClosedCounter;
    private final Counter supervisorStartedCounter;
    private final Counter supervisorStoppedCounter;
    private final Counter supervisorRunCounter;
    private final Counter dockerTimeoutCounter;
    private final Meter containerStartedMeter;
    private final Meter containersExitedMeter;
    private final Meter containersRunningMeter;
    private final Meter containersThrewExceptionMeter;
    private final Meter dockerTimeoutMeter;
    private final Meter imageCacheHitMeter;
    private final Meter supervisorClosedMeter;
    private final Meter supervisorStartedMeter;
    private final Meter supervisorStoppedMeter;
    private final Meter supervisorRunMeter;
    private final MetricName containerStartedCounterName;
    private final MetricName containersExitedCounterName;
    private final MetricName containersRunningCounterName;
    private final MetricName containersThrewExceptionCounterName;
    private final MetricName dockerTimeoutCounterName;
    private final MetricName imageCacheHitCounterName;
    private final MetricName supervisorClosedCounterName;
    private final MetricName supervisorStartedCounterName;
    private final MetricName supervisorStoppedCounterName;
    private final MetricName supervisorRunCounterName;
    private final MetricName containerStartedMeterName;
    private final MetricName containersExitedMeterName;
    private final MetricName containersRunningMeterName;
    private final MetricName containersThrewExceptionMeterName;
    private final MetricName dockerTimeoutMeterName;
    private final MetricName imageCacheHitMeterName;
    private final MetricName supervisorClosedMeterName;
    private final MetricName supervisorStartedMeterName;
    private final MetricName supervisorStoppedMeterName;
    private final MetricName supervisorRunMeterName;

    public SupervisorMetricsImpl(String group, MetricsRegistry registry) {
        this.containerStartedCounterName = new MetricName(group, TYPE, "container_started_counter");
        this.containersExitedCounterName = new MetricName(group, TYPE, "containers_exited_counter");
        this.containersRunningCounterName = new MetricName(group, TYPE, "containers_running_counter");
        this.containersThrewExceptionCounterName = new MetricName(group, TYPE, "containers_threw_exception_counter");
        this.imageCacheHitCounterName = new MetricName(group, TYPE, "image_cache_hit_counter");
        this.supervisorClosedCounterName = new MetricName(group, TYPE, "supervisor_closed_counter");
        this.supervisorStartedCounterName = new MetricName(group, TYPE, "supervisors_created_counter");
        this.supervisorStoppedCounterName = new MetricName(group, TYPE, "supervisor_stopped_counter");
        this.supervisorRunCounterName = new MetricName(group, TYPE, "supervisor_run_counter");
        this.dockerTimeoutCounterName = new MetricName(group, TYPE, "docker_timeout_counter");
        this.containerStartedMeterName = new MetricName(group, TYPE, "container_started_meter");
        this.containersExitedMeterName = new MetricName(group, TYPE, "containers_exited_meter");
        this.containersRunningMeterName = new MetricName(group, TYPE, "containers_running_meter");
        this.containersThrewExceptionMeterName = new MetricName(group, TYPE, "containers_threw_exception_meter");
        this.imageCacheHitMeterName = new MetricName(group, TYPE, "image_cache_hit_meter");
        this.supervisorClosedMeterName = new MetricName(group, TYPE, "supervisor_closed_meter");
        this.supervisorStartedMeterName = new MetricName(group, TYPE, "supervisors_created_meter");
        this.supervisorStoppedMeterName = new MetricName(group, TYPE, "supervisor_stopped_meter");
        this.supervisorRunMeterName = new MetricName(group, TYPE, "supervisor_run_meter");
        this.dockerTimeoutMeterName = new MetricName(group, TYPE, "docker_timeout_meter");
        this.containerStartedCounter = registry.newCounter(this.containerStartedCounterName);
        this.containersExitedCounter = registry.newCounter(this.containersExitedCounterName);
        this.containersRunningCounter = registry.newCounter(this.containersRunningCounterName);
        this.containersThrewExceptionCounter = registry.newCounter(this.containersThrewExceptionCounterName);
        this.imageCacheHitCounter = registry.newCounter(this.imageCacheHitCounterName);
        this.supervisorClosedCounter = registry.newCounter(this.supervisorClosedCounterName);
        this.supervisorStartedCounter = registry.newCounter(this.supervisorStartedCounterName);
        this.supervisorStoppedCounter = registry.newCounter(this.supervisorStoppedCounterName);
        this.supervisorRunCounter = registry.newCounter(this.supervisorRunCounterName);
        this.dockerTimeoutCounter = registry.newCounter(this.dockerTimeoutCounterName);
        this.containerStartedMeter = registry.newMeter(this.containerStartedMeterName, "container_starts", TimeUnit.MINUTES);
        this.containersExitedMeter = registry.newMeter(this.containersExitedMeterName, "containers_exits", TimeUnit.MINUTES);
        this.containersRunningMeter = registry.newMeter(this.containersRunningMeterName, "containers_ran", TimeUnit.MINUTES);
        this.containersThrewExceptionMeter = registry.newMeter(this.containersThrewExceptionMeterName, "container_exceptions", TimeUnit.MINUTES);
        this.imageCacheHitMeter = registry.newMeter(this.imageCacheHitMeterName, "image_cache_hits", TimeUnit.MINUTES);
        this.supervisorClosedMeter = registry.newMeter(this.supervisorClosedMeterName, "supervisor_closes", TimeUnit.MINUTES);
        this.supervisorStartedMeter = registry.newMeter(this.supervisorStartedMeterName, "supervisor_starts", TimeUnit.MINUTES);
        this.supervisorStoppedMeter = registry.newMeter(this.supervisorStoppedMeterName, "supervisor_stops", TimeUnit.MINUTES);
        this.supervisorRunMeter = registry.newMeter(this.supervisorRunMeterName, "supervisor_runs", TimeUnit.MINUTES);
        this.dockerTimeoutMeter = registry.newMeter(this.dockerTimeoutMeterName, "docker_timeouts", TimeUnit.MINUTES);
        this.imagePull = new RequestMetrics(group, TYPE, "image_pull", registry);
    }

    @Override
    public void supervisorStarted() {
        this.supervisorStartedCounter.inc();
        this.supervisorStartedMeter.mark();
    }

    @Override
    public void supervisorStopped() {
        this.supervisorStoppedCounter.inc();
        this.supervisorStoppedMeter.mark();
    }

    @Override
    public void supervisorClosed() {
        this.supervisorClosedCounter.inc();
        this.supervisorClosedMeter.mark();
    }

    @Override
    public void containersRunning() {
        this.containersRunningCounter.inc();
        this.containersRunningMeter.mark();
    }

    @Override
    public void containersExited() {
        this.containersExitedCounter.inc();
        this.containersExitedMeter.mark();
    }

    @Override
    public void containersThrewException() {
        this.containersThrewExceptionCounter.inc();
        this.containersThrewExceptionMeter.mark();
    }

    @Override
    public void containerStarted() {
        this.containerStartedCounter.inc();
        this.containerStartedMeter.mark();
    }

    @Override
    public MetricsContext containerPull() {
        return new MetricsContextImpl(this.imagePull);
    }

    @Override
    public void imageCacheHit() {
        this.imageCacheHitCounter.inc();
        this.imageCacheHitMeter.mark();
    }

    @Override
    public void imageCacheMiss() {
    }

    @Override
    public void dockerTimeout() {
        this.dockerTimeoutCounter.inc();
        this.dockerTimeoutMeter.mark();
    }

    @Override
    public MeterRates getDockerTimeoutRates() {
        return new MeterRates(this.dockerTimeoutMeter);
    }

    @Override
    public void supervisorRun() {
        this.supervisorRunCounter.inc();
        this.supervisorRunMeter.mark();
    }

    @Override
    public MeterRates getContainersThrewExceptionRates() {
        return new MeterRates(this.containersThrewExceptionMeter);
    }

    @Override
    public MeterRates getSupervisorRunRates() {
        return new MeterRates(this.supervisorRunMeter);
    }
}

