/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.net.InetAddresses;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.helios.agent.ContainerDecorator;
import com.spotify.helios.common.descriptors.Job;
import java.util.List;

public class AddExtraHostContainerDecorator
implements ContainerDecorator {
    private final List<String> extraHosts;

    public AddExtraHostContainerDecorator(List<String> extraHosts) {
        this.extraHosts = ImmutableList.copyOf(extraHosts);
    }

    @Override
    public void decorateHostConfig(Job job, Optional<String> dockerVersion, HostConfig.Builder hostConfig) {
        hostConfig.extraHosts(this.extraHosts);
    }

    @Override
    public void decorateContainerConfig(Job job, ImageInfo imageInfo, Optional<String> dockerVersion, ContainerConfig.Builder containerConfig) {
    }

    public static boolean isValidArg(String arg) {
        String[] args = arg.split(":");
        if (args.length != 2) {
            return false;
        }
        String ip = args[1];
        return InetAddresses.isInetAddress((String)ip);
    }
}

