/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.spotify.helios.agent.SignalAwaitingService;
import com.spotify.helios.common.descriptors.AgentInfo;
import com.spotify.helios.servicescommon.coordination.NodeUpdaterFactory;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperNodeUpdater;
import java.lang.management.RuntimeMXBean;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class AgentInfoReporter
extends SignalAwaitingService {
    private final RuntimeMXBean runtimeMXBean;
    private final ZooKeeperNodeUpdater nodeUpdater;
    private final int interval;
    private final TimeUnit timeUnit;

    AgentInfoReporter(RuntimeMXBean runtimeMXBean, NodeUpdaterFactory nodeUpdaterFactory, String host, int interval, TimeUnit timeUnit, CountDownLatch latch) {
        super(latch);
        this.runtimeMXBean = Objects.requireNonNull(runtimeMXBean);
        this.nodeUpdater = nodeUpdaterFactory.create(Paths.statusHostAgentInfo(host));
        this.interval = interval;
        this.timeUnit = Objects.requireNonNull(timeUnit);
    }

    @Override
    protected void runOneIteration() {
        AgentInfo agentInfo = AgentInfo.newBuilder().setName(this.runtimeMXBean.getName()).setVmName(this.runtimeMXBean.getVmName()).setVmVendor(this.runtimeMXBean.getVmVendor()).setVmVersion(this.runtimeMXBean.getVmVersion()).setSpecName(this.runtimeMXBean.getSpecName()).setSpecVendor(this.runtimeMXBean.getSpecVendor()).setSpecVersion(this.runtimeMXBean.getSpecVersion()).setInputArguments(this.runtimeMXBean.getInputArguments()).setUptime(this.runtimeMXBean.getUptime()).setStartTime(this.runtimeMXBean.getStartTime()).setVersion("0.9.54").build();
        this.nodeUpdater.update(agentInfo.toJsonBytes());
    }

    @Override
    protected ScheduledFuture<?> schedule(Runnable runnable, ScheduledExecutorService executorService) {
        return executorService.scheduleWithFixedDelay(runnable, 0L, this.interval, this.timeUnit);
    }
}

