/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.spotify.helios.agent.AgentConfig;
import com.spotify.helios.agent.AgentParser;
import com.spotify.helios.agent.AgentService;
import com.spotify.helios.common.LoggingConfig;
import com.spotify.helios.servicescommon.ServiceMain;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class AgentMain
extends ServiceMain {
    private final AgentConfig agentConfig;
    private AgentService service;

    public AgentMain(String ... args) throws ArgumentParserException {
        this(new AgentParser(args));
    }

    public AgentMain(AgentParser parser) {
        this(parser.getAgentConfig(), parser.getLoggingConfig());
    }

    public AgentMain(AgentConfig agentConfig, LoggingConfig loggingConfig) {
        super(loggingConfig, agentConfig.getSentryDsn());
        this.agentConfig = agentConfig;
    }

    protected void startUp() throws Exception {
        this.service = new AgentService(this.agentConfig, AgentMain.createEnvironment("helios-agent"));
        this.service.startAsync().awaitRunning();
    }

    protected void shutDown() throws Exception {
        if (this.service != null) {
            this.service.stopAsync().awaitTerminated();
        }
    }

    public static void main(String ... args) {
        AgentMain main;
        final AtomicBoolean exitSignalTriggered = new AtomicBoolean(false);
        final AtomicReference<Object> existingExitHandler = new AtomicReference<Object>(null);
        SignalHandler handler = new SignalHandler(){

            @Override
            public void handle(Signal signal) {
                if (exitSignalTriggered.get()) {
                    System.err.println("Exiting with extreme prejudice due to " + signal);
                    Runtime.getRuntime().halt(0);
                } else {
                    System.err.println("Attempting gentle exit on " + signal);
                    exitSignalTriggered.set(true);
                    ((SignalHandler)existingExitHandler.get()).handle(signal);
                }
            }
        };
        existingExitHandler.set(Signal.handle(new Signal("INT"), handler));
        Signal.handle(new Signal("TERM"), handler);
        try {
            main = new AgentMain(args);
        }
        catch (ArgumentParserException e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            main.startAsync().awaitRunning();
            main.awaitTerminated();
        }
        catch (Throwable e) {
            try {
                main.shutDown();
            }
            catch (Exception e1) {
                System.err.println("Error shutting down");
                e1.printStackTrace();
                System.err.println("Originating exception follows");
            }
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

