/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.io.BaseEncoding;
import com.google.common.net.InetAddresses;
import com.spotify.docker.client.DockerHost;
import com.spotify.helios.agent.AddExtraHostContainerDecorator;
import com.spotify.helios.agent.AgentConfig;
import com.spotify.helios.agent.BindVolumeContainerDecorator;
import com.spotify.helios.cli.Utils;
import com.spotify.helios.servicescommon.ServiceParser;
import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;

public class AgentParser
extends ServiceParser {
    private static final String ZK_AGENT_PASSWORD_ENVVAR = "HELIOS_ZK_AGENT_PASSWORD";
    private final AgentConfig agentConfig;
    private Argument noHttpArg;
    private Argument httpArg;
    private Argument adminArg;
    private Argument dockerArg;
    private Argument dockerCertPathArg;
    private Argument envArg;
    private Argument syslogRedirectToArg;
    private Argument portRangeArg;
    private Argument agentIdArg;
    private Argument dnsArg;
    private Argument bindArg;
    private Argument addHostArg;
    private Argument labelsArg;
    private Argument zkRegistrationTtlMinutesArg;
    private Argument zkAclMasterDigest;
    private Argument zkAclAgentPassword;
    private Argument disableJobHistory;

    public AgentParser(String ... args) throws ArgumentParserException {
        super("helios-agent", "Spotify Helios Agent", args);
        int end;
        int start;
        Map labels;
        Namespace options = this.getNamespace();
        DockerHost dockerHost = DockerHost.from((String)options.getString(this.dockerArg.getDest()), (String)options.getString(this.dockerCertPathArg.getDest()));
        Map envVars = Utils.argToStringMap((Namespace)options, (Argument)this.envArg);
        try {
            labels = Utils.argToStringMap((Namespace)options, (Argument)this.labelsArg);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + "\nLabels need to be in the format key=value.");
        }
        InetSocketAddress httpAddress = this.parseSocketAddress(options.getString(this.httpArg.getDest()));
        InetSocketAddress adminAddress = this.parseSocketAddress(options.getString(this.adminArg.getDest()));
        String portRangeString = options.getString(this.portRangeArg.getDest());
        List parts = Splitter.on((char)':').splitToList((CharSequence)portRangeString);
        if (parts.size() != 2) {
            throw new IllegalArgumentException("Bad port range: " + portRangeString);
        }
        try {
            start = Integer.valueOf((String)parts.get(0));
            end = Integer.valueOf((String)parts.get(1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Bad port range: " + portRangeString);
        }
        if (end <= start) {
            throw new IllegalArgumentException("Bad port range: " + portRangeString);
        }
        String agentPassword = System.getenv(ZK_AGENT_PASSWORD_ENVVAR);
        if (agentPassword == null) {
            agentPassword = options.getString(this.zkAclAgentPassword.getDest());
        }
        this.agentConfig = new AgentConfig().setName(this.getName()).setZooKeeperConnectionString(this.getZooKeeperConnectString()).setZooKeeperSessionTimeoutMillis(this.getZooKeeperSessionTimeoutMillis()).setZooKeeperConnectionTimeoutMillis(this.getZooKeeperConnectionTimeoutMillis()).setZooKeeperClusterId(this.getZooKeeperClusterId()).setZooKeeperRegistrationTtlMinutes(options.getInt(this.zkRegistrationTtlMinutesArg.getDest())).setZooKeeperEnableAcls(this.getZooKeeperEnableAcls()).setZookeeperAclMasterUser(this.getZooKeeperAclMasterUser()).setZooKeeperAclMasterDigest(options.getString(this.zkAclMasterDigest.getDest())).setZookeeperAclAgentUser(this.getZooKeeperAclAgentUser()).setZooKeeperAclAgentPassword(agentPassword).setDomain(this.getDomain()).setEnvVars(envVars).setDockerHost(dockerHost).setInhibitMetrics(this.getInhibitMetrics()).setRedirectToSyslog(options.getString(this.syslogRedirectToArg.getDest())).setStateDirectory(this.getStateDirectory()).setStatsdHostPort(this.getStatsdHostPort()).setRiemannHostPort(this.getRiemannHostPort()).setPortRange(start, end).setSentryDsn(this.getSentryDsn()).setServiceRegistryAddress(this.getServiceRegistryAddress()).setServiceRegistrarPlugin(this.getServiceRegistrarPlugin()).setAdminAddress(adminAddress).setHttpEndpoint(httpAddress).setNoHttp(options.getBoolean(this.noHttpArg.getDest())).setKafkaBrokers(this.getKafkaBrokers()).setPubsubPrefixes(this.getPubsubPrefixes()).setLabels(labels).setFfwdConfig(this.ffwdConfig(options)).setJobHistoryDisabled(options.getBoolean(this.disableJobHistory.getDest()));
        String explicitId = options.getString(this.agentIdArg.getDest());
        if (explicitId != null) {
            this.agentConfig.setId(explicitId);
        } else {
            byte[] idBytes = new byte[20];
            new SecureRandom().nextBytes(idBytes);
            this.agentConfig.setId(BaseEncoding.base16().encode(idBytes));
        }
        this.agentConfig.setDns(AgentParser.validateArgument(options.getList(this.dnsArg.getDest()), InetAddresses::isInetAddress, arg -> "Invalid IP address " + arg));
        this.agentConfig.setBinds(AgentParser.validateArgument(options.getList(this.bindArg.getDest()), BindVolumeContainerDecorator::isValidBind, arg -> "Invalid bind " + arg));
        this.agentConfig.setExtraHosts(AgentParser.validateArgument(options.getList(this.addHostArg.getDest()), AddExtraHostContainerDecorator::isValidArg, arg -> "Invalid ExtraHost " + arg));
    }

    @VisibleForTesting
    protected static <T> List<T> validateArgument(List<T> list, Predicate<T> predicate, Function<T, String> msgFn) {
        Optional firstInvalid = list.stream().filter(predicate.negate()).findAny();
        if (firstInvalid.isPresent()) {
            throw new IllegalArgumentException(firstInvalid.map(msgFn).get());
        }
        return list;
    }

    @Override
    protected void addArgs(ArgumentParser parser) {
        this.noHttpArg = parser.addArgument(new String[]{"--no-http"}).action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false).help("disable http server");
        this.httpArg = parser.addArgument(new String[]{"--http"}).setDefault((Object)"http://0.0.0.0:5803").help("http endpoint");
        this.adminArg = parser.addArgument(new String[]{"--admin"}).setDefault((Object)"http://0.0.0.0:5804").help("admin http port");
        this.agentIdArg = parser.addArgument(new String[]{"--id"}).help("Agent unique ID. Generated and persisted on first run if not specified.");
        this.dockerArg = parser.addArgument(new String[]{"--docker"}).setDefault((Object)DockerHost.fromEnv().host()).help("docker endpoint");
        this.dockerCertPathArg = parser.addArgument(new String[]{"--docker-cert-path"}).setDefault((Object)DockerHost.fromEnv().dockerCertPath()).help("directory containing client.pem and client.key for connecting to Docker over HTTPS");
        this.envArg = parser.addArgument(new String[]{"--env"}).action((ArgumentAction)Arguments.append()).setDefault(new ArrayList()).nargs("+").help("Specify environment variables that will pass down to all containers");
        this.syslogRedirectToArg = parser.addArgument(new String[]{"--syslog-redirect-to"}).help("redirect container's stdout/stderr to syslog running at host:port");
        this.portRangeArg = parser.addArgument(new String[]{"--port-range"}).setDefault((Object)"20000:32768").help("Port allocation range, start:end (end exclusive).");
        this.dnsArg = parser.addArgument(new String[]{"--dns"}).action((ArgumentAction)Arguments.append()).setDefault(new ArrayList()).help("Dns servers to use.");
        this.bindArg = parser.addArgument(new String[]{"--bind"}).action((ArgumentAction)Arguments.append()).setDefault(new ArrayList()).help("volumes to bind to all containers");
        this.addHostArg = parser.addArgument(new String[]{"--add-host"}).action((ArgumentAction)Arguments.append()).setDefault(new ArrayList()).help("extra hosts to add to /etc/hosts of created containers, in form `host:ip`. See docker documentation for --add-host for more info.");
        this.labelsArg = parser.addArgument(new String[]{"--labels"}).action((ArgumentAction)Arguments.append()).setDefault(new ArrayList()).nargs("+").help("labels to apply to this agent. Labels need to be in the format key=value.");
        this.zkRegistrationTtlMinutesArg = parser.addArgument(new String[]{"--zk-registration-ttl"}).type(Integer.class).setDefault((Object)10).help("Number of minutes that this agent must be DOWN (i.e. not periodically check-in with ZooKeeper) before another agent with the same hostname but lacking the registration ID of this one can automatically deregister this one and register itself. This is useful when the agent loses its registration ID and you don't want to waste time debugging why the master lists your agent as constantly DOWN.");
        this.zkAclMasterDigest = parser.addArgument(new String[]{"--zk-acl-master-digest"}).type(String.class);
        this.zkAclAgentPassword = parser.addArgument(new String[]{"--zk-acl-agent-password"}).type(String.class).help("ZooKeeper agent password (for ZooKeeper ACLs). If the HELIOS_ZK_AGENT_PASSWORD environment variable is present this argument is ignored.");
        this.disableJobHistory = parser.addArgument(new String[]{"--disable-job-history"}).action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false).help("If specified, the agent won't write job histories to ZooKeeper.");
    }

    public AgentConfig getAgentConfig() {
        return this.agentConfig;
    }
}

