/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import com.google.common.util.concurrent.AbstractIdleService;
import com.spotify.docker.client.DockerCertificates;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.spotify.helios.agent.AddExtraHostContainerDecorator;
import com.spotify.helios.agent.Agent;
import com.spotify.helios.agent.AgentConfig;
import com.spotify.helios.agent.AgentInfoReporter;
import com.spotify.helios.agent.AgentModelTaskResource;
import com.spotify.helios.agent.AgentModelTaskStatusResource;
import com.spotify.helios.agent.AgentZooKeeperRegistrar;
import com.spotify.helios.agent.BindVolumeContainerDecorator;
import com.spotify.helios.agent.DockerHealthChecker;
import com.spotify.helios.agent.EnvironmentVariableReporter;
import com.spotify.helios.agent.Execution;
import com.spotify.helios.agent.HostInfoReporter;
import com.spotify.helios.agent.LabelReporter;
import com.spotify.helios.agent.MonitoredDockerClient;
import com.spotify.helios.agent.PollingDockerClient;
import com.spotify.helios.agent.PortAllocator;
import com.spotify.helios.agent.Reaper;
import com.spotify.helios.agent.SupervisorFactory;
import com.spotify.helios.agent.SyslogRedirectingContainerDecorator;
import com.spotify.helios.agent.TaskHistoryWriter;
import com.spotify.helios.agent.ZooKeeperAgentModel;
import com.spotify.helios.common.Clock;
import com.spotify.helios.common.HeliosRuntimeException;
import com.spotify.helios.common.SystemClock;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.master.metrics.HealthCheckGauge;
import com.spotify.helios.serviceregistration.ServiceRegistrar;
import com.spotify.helios.servicescommon.EventSender;
import com.spotify.helios.servicescommon.FastForwardConfig;
import com.spotify.helios.servicescommon.GooglePubSubProvider;
import com.spotify.helios.servicescommon.KafkaClientProvider;
import com.spotify.helios.servicescommon.KafkaSender;
import com.spotify.helios.servicescommon.ManagedStatsdReporter;
import com.spotify.helios.servicescommon.PersistentAtomicReference;
import com.spotify.helios.servicescommon.ReactorFactory;
import com.spotify.helios.servicescommon.RiemannFacade;
import com.spotify.helios.servicescommon.RiemannHeartBeat;
import com.spotify.helios.servicescommon.RiemannSupport;
import com.spotify.helios.servicescommon.ServiceRegistrars;
import com.spotify.helios.servicescommon.ServiceUtil;
import com.spotify.helios.servicescommon.ZooKeeperAclProviders;
import com.spotify.helios.servicescommon.ZooKeeperRegistrarService;
import com.spotify.helios.servicescommon.coordination.CuratorClientFactoryImpl;
import com.spotify.helios.servicescommon.coordination.DefaultZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClientProvider;
import com.spotify.helios.servicescommon.coordination.ZooKeeperHealthChecker;
import com.spotify.helios.servicescommon.coordination.ZooKeeperModelReporter;
import com.spotify.helios.servicescommon.coordination.ZooKeeperNodeUpdaterFactory;
import com.spotify.helios.servicescommon.statistics.DockerVersionSupplier;
import com.spotify.helios.servicescommon.statistics.FastForwardReporter;
import com.spotify.helios.servicescommon.statistics.Metrics;
import com.spotify.helios.servicescommon.statistics.MetricsImpl;
import com.spotify.helios.servicescommon.statistics.NoopMetrics;
import com.sun.management.OperatingSystemMXBean;
import io.dropwizard.configuration.ConfigurationException;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentService
extends AbstractIdleService
implements Managed {
    private static final Logger log = LoggerFactory.getLogger(AgentService.class);
    private static final String TASK_HISTORY_FILENAME = "task-history.json";
    private static final TypeReference<Map<JobId, Execution>> JOBID_EXECUTIONS_MAP = new TypeReference<Map<JobId, Execution>>(){};
    private final Agent agent;
    private final Server server;
    private final ZooKeeperClient zooKeeperClient;
    private final HostInfoReporter hostInfoReporter;
    private final AgentInfoReporter agentInfoReporter;
    private final EnvironmentVariableReporter environmentVariableReporter;
    private final LabelReporter labelReporter;
    private final FileChannel stateLockFile;
    private final FileLock stateLock;
    private final ZooKeeperAgentModel model;
    private final Metrics metrics;
    private final ServiceRegistrar serviceRegistrar;
    private ZooKeeperRegistrarService zkRegistrar;

    public AgentService(AgentConfig config, Environment environment) throws ConfigurationException, InterruptedException, IOException {
        PersistentAtomicReference<Map<JobId, Execution>> executions;
        String id;
        Path stateDirectory = config.getStateDirectory().toAbsolutePath().normalize();
        if (!Files.exists(stateDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(stateDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error("Failed to create state directory: {}", (Object)stateDirectory, (Object)e);
                throw Throwables.propagate((Throwable)e);
            }
        }
        Path lockPath = config.getStateDirectory().resolve("lock");
        try {
            this.stateLockFile = FileChannel.open(lockPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            this.stateLock = this.stateLockFile.tryLock();
            if (this.stateLock == null) {
                throw new IllegalStateException("State lock file already locked: " + lockPath);
            }
        }
        catch (OverlappingFileLockException e) {
            throw new IllegalStateException("State lock file already locked: " + lockPath);
        }
        catch (IOException e) {
            log.error("Failed to take state lock: {}", (Object)lockPath, (Object)e);
            throw Throwables.propagate((Throwable)e);
        }
        Path idPath = config.getStateDirectory().resolve("id");
        try {
            if (Files.exists(idPath, new LinkOption[0])) {
                id = new String(Files.readAllBytes(idPath), Charsets.UTF_8);
            } else {
                id = config.getId();
                Files.write(idPath, id.getBytes(Charsets.UTF_8), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            log.error("Failed to set up id file: {}", (Object)idPath, (Object)e);
            throw Throwables.propagate((Throwable)e);
        }
        MetricRegistry metricsRegistry = environment.metrics();
        metricsRegistry.registerAll((MetricSet)new GarbageCollectorMetricSet());
        metricsRegistry.registerAll((MetricSet)new MemoryUsageGaugeSet());
        RiemannSupport riemannSupport = new RiemannSupport(metricsRegistry, config.getRiemannHostPort(), config.getName(), "helios-agent");
        RiemannFacade riemannFacade = riemannSupport.getFacade();
        DockerClient dockerClient = this.createDockerClient(config, riemannFacade);
        if (config.isInhibitMetrics()) {
            log.info("Not starting metrics");
            this.metrics = new NoopMetrics();
        } else {
            FastForwardConfig ffwdConfig;
            log.info("Starting metrics");
            this.metrics = new MetricsImpl(metricsRegistry, MetricsImpl.Type.AGENT);
            environment.lifecycle().manage((Managed)riemannSupport);
            if (!Strings.isNullOrEmpty((String)config.getStatsdHostPort())) {
                environment.lifecycle().manage((Managed)new ManagedStatsdReporter(config.getStatsdHostPort(), metricsRegistry));
            }
            if ((ffwdConfig = config.getFfwdConfig()) != null) {
                DockerVersionSupplier versionSupplier = new DockerVersionSupplier(dockerClient);
                Supplier<Map<String, String>> attributesSupplier = () -> ImmutableMap.of((Object)"docker_version", (Object)versionSupplier.get());
                FastForwardReporter reporter = FastForwardReporter.create(metricsRegistry, ffwdConfig.getAddress(), ffwdConfig.getMetricKey(), ffwdConfig.getReportingIntervalSeconds(), attributesSupplier);
                environment.lifecycle().manage((Managed)reporter);
            }
        }
        CountDownLatch zkRegistrationSignal = new CountDownLatch(1);
        this.zooKeeperClient = this.setupZookeeperClient(config, id, zkRegistrationSignal);
        DockerHealthChecker dockerHealthChecker = new DockerHealthChecker(this.metrics.getSupervisorMetrics(), TimeUnit.SECONDS, 30, riemannFacade);
        environment.lifecycle().manage((Managed)dockerHealthChecker);
        environment.lifecycle().manage((Managed)new RiemannHeartBeat(TimeUnit.MINUTES, 2, riemannFacade));
        ZooKeeperModelReporter modelReporter = new ZooKeeperModelReporter(riemannFacade, this.metrics.getZooKeeperMetrics());
        ZooKeeperClientProvider zkClientProvider = new ZooKeeperClientProvider(this.zooKeeperClient, modelReporter);
        KafkaClientProvider kafkaClientProvider = new KafkaClientProvider(config.getKafkaBrokers());
        GooglePubSubProvider googlePubSubProvider = new GooglePubSubProvider(config.getPubsubPrefixes());
        ImmutableList.Builder eventSenders = ImmutableList.builder();
        Optional<KafkaProducer<String, byte[]>> kafkaProducer = kafkaClientProvider.getDefaultProducer();
        if (kafkaProducer.isPresent()) {
            eventSenders.add((Object)new KafkaSender(kafkaProducer));
        }
        eventSenders.addAll(googlePubSubProvider.senders());
        TaskHistoryWriter historyWriter = config.isJobHistoryDisabled() ? null : new TaskHistoryWriter(config.getName(), this.zooKeeperClient, stateDirectory.resolve(TASK_HISTORY_FILENAME));
        try {
            this.model = new ZooKeeperAgentModel(zkClientProvider, config.getName(), stateDirectory, historyWriter, (List<EventSender>)eventSenders.build());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.serviceRegistrar = ServiceRegistrars.createServiceRegistrar(config.getServiceRegistrarPlugin(), config.getServiceRegistryAddress(), config.getDomain());
        ZooKeeperNodeUpdaterFactory nodeUpdaterFactory = new ZooKeeperNodeUpdaterFactory(this.zooKeeperClient);
        this.hostInfoReporter = new HostInfoReporter((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean(), nodeUpdaterFactory, config.getName(), dockerClient, config.getDockerHost(), 1, TimeUnit.MINUTES, zkRegistrationSignal);
        this.agentInfoReporter = new AgentInfoReporter(ManagementFactory.getRuntimeMXBean(), nodeUpdaterFactory, config.getName(), 1, TimeUnit.MINUTES, zkRegistrationSignal);
        this.environmentVariableReporter = new EnvironmentVariableReporter(config.getName(), config.getEnvVars(), nodeUpdaterFactory, zkRegistrationSignal);
        this.labelReporter = new LabelReporter(config.getName(), config.getLabels(), nodeUpdaterFactory, zkRegistrationSignal);
        String namespace = "helios-" + id;
        ArrayList decorators = Lists.newArrayList();
        if (!Strings.isNullOrEmpty((String)config.getRedirectToSyslog())) {
            decorators.add(new SyslogRedirectingContainerDecorator(config.getRedirectToSyslog()));
        }
        if (!config.getBinds().isEmpty()) {
            decorators.add(new BindVolumeContainerDecorator(config.getBinds()));
        }
        if (!config.getExtraHosts().isEmpty()) {
            decorators.add(new AddExtraHostContainerDecorator(config.getExtraHosts()));
        }
        SupervisorFactory supervisorFactory = new SupervisorFactory(this.model, dockerClient, config.getEnvVars(), this.serviceRegistrar, decorators, config.getDockerHost(), config.getName(), this.metrics.getSupervisorMetrics(), namespace, config.getDomain(), config.getDns());
        ReactorFactory reactorFactory = new ReactorFactory();
        PortAllocator portAllocator = new PortAllocator(config.getPortRangeStart(), config.getPortRangeEnd());
        try {
            executions = PersistentAtomicReference.create(stateDirectory.resolve("executions.json"), JOBID_EXECUTIONS_MAP, Suppliers.ofInstance(Agent.EMPTY_EXECUTIONS));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        Reaper reaper = new Reaper(dockerClient, namespace);
        this.agent = new Agent(this.model, supervisorFactory, reactorFactory, executions, portAllocator, reaper);
        ZooKeeperHealthChecker zkHealthChecker = new ZooKeeperHealthChecker(this.zooKeeperClient, Paths.statusHosts(), riemannFacade, TimeUnit.MINUTES, 2L);
        environment.lifecycle().manage((Managed)zkHealthChecker);
        if (!config.getNoHttp()) {
            environment.healthChecks().register("docker", (HealthCheck)dockerHealthChecker);
            environment.healthChecks().register("zookeeper", (HealthCheck)zkHealthChecker);
            environment.healthChecks().getNames().forEach(name -> {
                HealthCheckGauge cfr_ignored_0 = (HealthCheckGauge)environment.metrics().register("helios." + name + ".ok", (Metric)new HealthCheckGauge(environment.healthChecks(), (String)name));
            });
            environment.jersey().register((Object)new AgentModelTaskResource(this.model));
            environment.jersey().register((Object)new AgentModelTaskStatusResource(this.model));
            environment.lifecycle().manage((Managed)this);
            this.server = ServiceUtil.createServerFactory(config.getHttpEndpoint(), config.getAdminEndpoint(), config.getNoHttp()).build(environment);
        } else {
            this.server = null;
        }
        environment.lifecycle().manage((Managed)this);
    }

    private DockerClient createDockerClient(AgentConfig config, RiemannFacade riemannFacade) {
        PollingDockerClient dockerClient;
        if (Strings.isNullOrEmpty((String)config.getDockerHost().dockerCertPath())) {
            dockerClient = new PollingDockerClient(config.getDockerHost().uri());
        } else {
            DockerCertificates dockerCertificates;
            Path dockerCertPath = java.nio.file.Paths.get(config.getDockerHost().dockerCertPath(), new String[0]);
            try {
                dockerCertificates = new DockerCertificates(dockerCertPath);
            }
            catch (DockerCertificateException e) {
                throw Throwables.propagate((Throwable)e);
            }
            dockerClient = new PollingDockerClient(config.getDockerHost().uri(), dockerCertificates);
        }
        return MonitoredDockerClient.wrap(riemannFacade, (DockerClient)dockerClient);
    }

    private ZooKeeperClient setupZookeeperClient(AgentConfig config, String id, CountDownLatch zkRegistrationSignal) {
        ACLProvider aclProvider = null;
        ArrayList authorization = null;
        String agentUser = config.getZookeeperAclAgentUser();
        String agentPassword = config.getZooKeeperAclAgentPassword();
        String masterUser = config.getZookeeperAclMasterUser();
        String masterDigest = config.getZooKeeperAclMasterDigest();
        if (!Strings.isNullOrEmpty((String)agentPassword)) {
            if (Strings.isNullOrEmpty((String)agentUser)) {
                throw new HeliosRuntimeException("Agent username must be set if a password is set");
            }
            authorization = Lists.newArrayList((Object[])new AuthInfo[]{new AuthInfo("digest", String.format("%s:%s", agentUser, agentPassword).getBytes())});
        }
        if (config.isZooKeeperEnableAcls()) {
            if (Strings.isNullOrEmpty((String)agentUser) || Strings.isNullOrEmpty((String)agentPassword)) {
                throw new HeliosRuntimeException("ZooKeeper ACLs enabled but agent username and/or password not set");
            }
            if (Strings.isNullOrEmpty((String)masterUser) || Strings.isNullOrEmpty((String)masterDigest)) {
                throw new HeliosRuntimeException("ZooKeeper ACLs enabled but master username and/or digest not set");
            }
            aclProvider = ZooKeeperAclProviders.heliosAclProvider(masterUser, masterDigest, agentUser, ZooKeeperAclProviders.digest(agentUser, agentPassword));
        }
        ExponentialBackoffRetry zooKeeperRetryPolicy = new ExponentialBackoffRetry(1000, 3);
        CuratorFramework curator = new CuratorClientFactoryImpl().newClient(config.getZooKeeperConnectionString(), config.getZooKeeperSessionTimeoutMillis(), config.getZooKeeperConnectionTimeoutMillis(), (RetryPolicy)zooKeeperRetryPolicy, aclProvider, authorization);
        DefaultZooKeeperClient client = new DefaultZooKeeperClient(curator, config.getZooKeeperClusterId());
        client.start();
        AgentZooKeeperRegistrar agentZooKeeperRegistrar = new AgentZooKeeperRegistrar(config.getName(), id, config.getZooKeeperRegistrationTtlMinutes(), (Clock)new SystemClock());
        this.zkRegistrar = ZooKeeperRegistrarService.newBuilder().setZooKeeperClient(client).setZooKeeperRegistrar(agentZooKeeperRegistrar).setZKRegistrationSignal(zkRegistrationSignal).build();
        return client;
    }

    protected void startUp() throws Exception {
        this.logBanner();
        this.zkRegistrar.startAsync().awaitRunning();
        this.model.startAsync().awaitRunning();
        this.agent.startAsync().awaitRunning();
        this.hostInfoReporter.startAsync();
        this.agentInfoReporter.startAsync();
        this.environmentVariableReporter.startAsync();
        this.labelReporter.startAsync();
        this.metrics.start();
        if (this.server != null) {
            try {
                this.server.start();
            }
            catch (Exception e) {
                log.error("Unable to start server, shutting down", (Throwable)e);
                this.server.stop();
            }
        }
    }

    private void logBanner() {
        try {
            String banner = Resources.toString((URL)Resources.getResource((String)"agent-banner.txt"), (Charset)Charsets.UTF_8);
            log.info("\n{}", (Object)banner);
        }
        catch (IOException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    protected void shutDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        this.hostInfoReporter.stopAsync().awaitTerminated();
        this.agentInfoReporter.stopAsync().awaitTerminated();
        this.environmentVariableReporter.stopAsync().awaitTerminated();
        this.labelReporter.stopAsync().awaitTerminated();
        this.agent.stopAsync().awaitTerminated();
        if (this.serviceRegistrar != null) {
            this.serviceRegistrar.close();
        }
        this.zkRegistrar.stopAsync().awaitTerminated();
        this.model.stopAsync().awaitTerminated();
        this.metrics.stop();
        this.zooKeeperClient.close();
        try {
            this.stateLock.release();
        }
        catch (IOException e) {
            log.error("Failed to release state lock", (Throwable)e);
        }
        try {
            this.stateLockFile.close();
        }
        catch (IOException e) {
            log.error("Failed to close state lock file", (Throwable)e);
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        this.shutDown();
    }
}

