/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.spotify.helios.common.Clock;
import com.spotify.helios.master.HostNotFoundException;
import com.spotify.helios.servicescommon.ZooKeeperRegistrar;
import com.spotify.helios.servicescommon.ZooKeeperRegistrarUtil;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperClient;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.recipes.nodes.PersistentEphemeralNode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentZooKeeperRegistrar
implements ZooKeeperRegistrar {
    private static final Logger log = LoggerFactory.getLogger(AgentZooKeeperRegistrar.class);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final String name;
    private final String id;
    private final long zooKeeperRegistrationTtlMillis;
    private Clock clock;
    private PersistentEphemeralNode upNode;

    public AgentZooKeeperRegistrar(String name, String id, int zooKeeperRegistrationTtlMinutes, Clock clock) {
        this.name = name;
        this.id = id;
        this.zooKeeperRegistrationTtlMillis = TimeUnit.MILLISECONDS.convert(zooKeeperRegistrationTtlMinutes, TimeUnit.MINUTES);
        this.clock = clock;
    }

    @Override
    public void startUp() throws Exception {
    }

    @Override
    public void shutDown() throws Exception {
        if (this.upNode != null) {
            try {
                this.upNode.close();
            }
            catch (IOException e) {
                Throwable cause = (Throwable)Optional.fromNullable((Object)e.getCause()).or((Object)e);
                log.warn("Exception on closing up node: {}", cause);
            }
        }
    }

    @Override
    public boolean tryToRegister(ZooKeeperClient client) throws KeeperException, HostNotFoundException {
        String idPath = Paths.configHostId(this.name);
        String hostInfoPath = Paths.statusHostInfo(this.name);
        Stat stat = client.exists(idPath);
        if (stat == null) {
            log.debug("Agent id node not present, registering agent {}: {}", (Object)this.id, (Object)this.name);
            ZooKeeperRegistrarUtil.registerHost(client, idPath, this.name, this.id);
        } else {
            String existingId;
            byte[] bytes = client.getData(idPath);
            String string = existingId = bytes == null ? "" : new String(bytes, Charsets.UTF_8);
            if (!this.id.equals(existingId)) {
                Stat hostInfoStat = client.stat(hostInfoPath);
                if (hostInfoStat != null) {
                    long mtime = hostInfoStat.getMtime();
                    long diff = this.clock.now().getMillis() - mtime;
                    if (diff < this.zooKeeperRegistrationTtlMillis) {
                        String message = String.format("Another agent already registered as '%s' (local=%s remote=%s). That agent's registration expires in %d seconds", this.name, this.id.trim(), existingId.trim(), TimeUnit.MILLISECONDS.toSeconds(this.zooKeeperRegistrationTtlMillis - diff));
                        log.warn(message);
                        return false;
                    }
                    log.info("Another agent has already registered as '{}', but its ID node was last updated more than {} milliseconds ago. I'm deregistering the agent with the old ID of {} and replacing it with this new agent with ID '{}'.", new Object[]{this.name, this.zooKeeperRegistrationTtlMillis, existingId.trim(), this.id.trim()});
                } else {
                    log.info("Another agent has registered as '{}', but it never updated '{}' in ZooKeeper. I'll assume it's dead and deregister it.", (Object)this.name, (Object)hostInfoPath);
                }
                ZooKeeperRegistrarUtil.reRegisterHost(client, this.name, this.id);
            } else {
                log.info("Matching agent id node already present, not registering agent {}: {}", (Object)this.id, (Object)this.name);
            }
        }
        if (this.upNode == null) {
            String upPath = Paths.statusHostUp(this.name);
            log.debug("Creating up node: {}", (Object)upPath);
            client.ensurePath(upPath, true);
            this.upNode = client.persistentEphemeralNode(upPath, PersistentEphemeralNode.Mode.EPHEMERAL, EMPTY_BYTES);
            this.upNode.start();
        }
        log.info("ZooKeeper registration complete");
        return true;
    }
}

