/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.helios.agent.ContainerDecorator;
import com.spotify.helios.common.descriptors.Job;
import java.util.ArrayList;
import java.util.List;

public class BindVolumeContainerDecorator
implements ContainerDecorator {
    private final List<String> binds;

    public BindVolumeContainerDecorator(List<String> binds) {
        this.binds = ImmutableList.copyOf(binds);
    }

    public static boolean isValidBind(String bind) {
        if (Strings.isNullOrEmpty((String)bind)) {
            return false;
        }
        String[] parts = bind.split(":");
        if (Strings.isNullOrEmpty((String)parts[0])) {
            return false;
        }
        if (parts.length > 1 && Strings.isNullOrEmpty((String)parts[1])) {
            return false;
        }
        if (parts.length > 2 && !parts[2].equals("ro") && !parts[2].equals("rw")) {
            return false;
        }
        return parts.length <= 3;
    }

    @Override
    public void decorateHostConfig(Job job, Optional<String> dockerVersion, HostConfig.Builder hostConfig) {
        ArrayList b = Lists.newArrayList();
        if (hostConfig.binds() != null) {
            b.addAll(hostConfig.binds());
        }
        b.addAll(this.binds);
        hostConfig.binds((List)b);
    }

    @Override
    public void decorateContainerConfig(Job job, ImageInfo imageInfo, Optional<String> dockerVersion, ContainerConfig.Builder containerConfig) {
    }
}

