/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.spotify.helios.agent.RetryIntervalPolicy;
import com.spotify.helios.agent.RetryScheduler;
import java.util.concurrent.TimeUnit;

public class BoundedRandomExponentialBackoff
implements RetryIntervalPolicy {
    public static final long DEFAULT_MIN_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    public static final long DEFAULT_MAX_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    public static final float DEFAULT_RANDOMIZATION_FACTOR = 0.5f;
    private final long minIntervalMillis;
    private final long maxIntervalMillis;
    private final float randomizationFactor;

    public BoundedRandomExponentialBackoff(long minIntervalMillis, long maxIntervalMillis, float randomizationFactor) {
        Preconditions.checkArgument((boolean)Range.closed((Comparable)Float.valueOf(0.0f), (Comparable)Float.valueOf(1.0f)).contains((Comparable)Float.valueOf(randomizationFactor)), (Object)"randomization factor must be in in [0.0, 1.0]");
        Preconditions.checkArgument((minIntervalMillis > 0L ? 1 : 0) != 0, (Object)"min interval must be positive");
        Preconditions.checkArgument((maxIntervalMillis > 0L ? 1 : 0) != 0, (Object)"max interval must be positive");
        Preconditions.checkArgument((minIntervalMillis <= maxIntervalMillis ? 1 : 0) != 0, (Object)"min interval must be less or equal to max interval");
        this.minIntervalMillis = minIntervalMillis;
        this.maxIntervalMillis = maxIntervalMillis;
        this.randomizationFactor = randomizationFactor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public RetryScheduler newScheduler() {
        return new RetryScheduler(){
            private long intervalMillis;

            @Override
            public long currentMillis() {
                if (this.intervalMillis == 0L) {
                    return BoundedRandomExponentialBackoff.this.minIntervalMillis;
                }
                return this.intervalMillis;
            }

            @Override
            public long nextMillis() {
                if (this.intervalMillis == 0L) {
                    this.intervalMillis = BoundedRandomExponentialBackoff.this.minIntervalMillis;
                } else {
                    double factor = 2.0 + this.random(-1.0, 1.0) * (double)BoundedRandomExponentialBackoff.this.randomizationFactor;
                    long newIntervalMillis = (long)((double)this.intervalMillis * factor);
                    this.intervalMillis = Math.max(BoundedRandomExponentialBackoff.this.minIntervalMillis, Math.min(BoundedRandomExponentialBackoff.this.maxIntervalMillis, newIntervalMillis));
                }
                return this.intervalMillis;
            }

            private double random(double min, double max) {
                return min + (max - min) * Math.random();
            }
        };
    }

    public static class Builder {
        private long minIntervalMillis = DEFAULT_MIN_INTERVAL_MILLIS;
        private long maxIntervalMillis = DEFAULT_MAX_INTERVAL_MILLIS;
        private float randomizationFactor = 0.5f;

        private Builder() {
        }

        public Builder setMinInterval(long minInterval, TimeUnit timeUnit) {
            return this.setMinIntervalMillis(timeUnit.toMillis(minInterval));
        }

        public Builder setMaxInterval(long maxInterval, TimeUnit timeUnit) {
            return this.setMaxIntervalMillis(timeUnit.toMillis(maxInterval));
        }

        public Builder setMinIntervalMillis(long minIntervalMillis) {
            this.minIntervalMillis = minIntervalMillis;
            return this;
        }

        public Builder setMaxIntervalMillis(long maxIntervalMillis) {
            this.maxIntervalMillis = maxIntervalMillis;
            return this;
        }

        public Builder setRandomizationFactor(float randomizationFactor) {
            this.randomizationFactor = randomizationFactor;
            return this;
        }

        public BoundedRandomExponentialBackoff build() {
            return new BoundedRandomExponentialBackoff(this.minIntervalMillis, this.maxIntervalMillis, this.randomizationFactor);
        }
    }
}

