/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import com.spotify.helios.common.Clock;
import com.spotify.helios.common.SystemClock;
import java.util.Deque;

public class FlapController {
    private static final int DEFAULT_FLAPPING_RESTART_COUNT = 10;
    private static final long DEFAULT_FLAPPING_TIME_RANGE_MILLIS = 60000L;
    private final int restartCount;
    private final long timeRangeMillis;
    private final Clock clock;
    private final Deque<Long> exits = Queues.newArrayDeque();
    private volatile long startMillis;
    private volatile boolean running;

    private FlapController(Builder builder) {
        this.restartCount = builder.restartCount;
        this.timeRangeMillis = builder.timeRangeMillis;
        this.clock = (Clock)Preconditions.checkNotNull((Object)builder.clock, (Object)"clock");
    }

    public synchronized void started() {
        this.running = true;
        this.startMillis = this.clock.now().getMillis();
    }

    public synchronized void exited() {
        this.running = false;
        this.exits.add(this.clock.now().getMillis() - this.startMillis);
        while (this.exits.size() > this.restartCount) {
            this.exits.pop();
        }
    }

    public boolean isFlapping() {
        return this.millisLeftToUnflap() > 0L;
    }

    public long millisLeftToUnflap() {
        if (this.exits.size() < this.restartCount) {
            return 0L;
        }
        return this.timeRangeMillis - this.totalRunningTimeMillis();
    }

    private long totalRunningTimeMillis() {
        int duration = 0;
        for (Long exit : this.exits) {
            duration = (int)((long)duration + exit);
        }
        if (this.running) {
            duration = (int)((long)duration + (this.clock.now().getMillis() - this.startMillis));
        }
        return duration;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static FlapController create() {
        return FlapController.newBuilder().build();
    }

    public static class Builder {
        private int restartCount = 10;
        private long timeRangeMillis = 60000L;
        private Clock clock = new SystemClock();

        private Builder() {
        }

        public Builder setRestartCount(int restartCount) {
            this.restartCount = restartCount;
            return this;
        }

        public Builder setTimeRangeMillis(long timeRangeMillis) {
            this.timeRangeMillis = timeRangeMillis;
            return this;
        }

        public Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public FlapController build() {
            return new FlapController(this);
        }
    }
}

