/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.io.CharStreams;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerHost;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.Version;
import com.spotify.helios.agent.SignalAwaitingService;
import com.spotify.helios.common.descriptors.DockerVersion;
import com.spotify.helios.common.descriptors.HostInfo;
import com.spotify.helios.servicescommon.coordination.NodeUpdaterFactory;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperNodeUpdater;
import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class HostInfoReporter
extends SignalAwaitingService {
    private final OperatingSystemMXBean operatingSystemMXBean;
    private final ZooKeeperNodeUpdater nodeUpdater;
    private final int interval;
    private final TimeUnit timeUnit;
    private final DockerClient dockerClient;
    private final DockerHost dockerHost;

    HostInfoReporter(OperatingSystemMXBean operatingSystemMXBean, NodeUpdaterFactory nodeUpdaterFactory, String host, DockerClient dockerClient, DockerHost dockerHost, int interval, TimeUnit timeUnit, CountDownLatch latch) {
        super(latch);
        this.operatingSystemMXBean = Objects.requireNonNull(operatingSystemMXBean, "operatingSystemMXBean");
        String hostInfoPath = Paths.statusHostInfo(Objects.requireNonNull(host, "host"));
        this.nodeUpdater = nodeUpdaterFactory.create(hostInfoPath);
        this.dockerClient = Objects.requireNonNull(dockerClient, "dockerClient");
        this.dockerHost = Objects.requireNonNull(dockerHost, "dockerHost");
        this.interval = interval;
        this.timeUnit = Objects.requireNonNull(timeUnit, "timeUnit");
    }

    @Override
    protected void runOneIteration() throws InterruptedException {
        String hostname = this.exec("uname -n").trim();
        String uname = this.exec("uname -a").trim();
        HostInfo hostInfo = HostInfo.newBuilder().setArchitecture(this.operatingSystemMXBean.getArch()).setCpus(Runtime.getRuntime().availableProcessors()).setHostname(hostname).setLoadAvg(this.operatingSystemMXBean.getSystemLoadAverage()).setOsName(this.operatingSystemMXBean.getName()).setOsVersion(this.operatingSystemMXBean.getVersion()).setMemoryFreeBytes(this.operatingSystemMXBean.getFreePhysicalMemorySize()).setMemoryTotalBytes(this.operatingSystemMXBean.getTotalPhysicalMemorySize()).setSwapFreeBytes(this.operatingSystemMXBean.getFreeSwapSpaceSize()).setSwapTotalBytes(this.operatingSystemMXBean.getTotalSwapSpaceSize()).setUname(uname).setDockerVersion(this.dockerVersion()).setDockerHost(this.dockerHost()).setDockerCertPath(this.dockerHost.dockerCertPath()).build();
        this.nodeUpdater.update(hostInfo.toJsonBytes());
    }

    private DockerVersion dockerVersion() throws InterruptedException {
        try {
            Version version = this.dockerClient.version();
            return version == null ? null : this.dockerVersion(version);
        }
        catch (DockerException e) {
            return null;
        }
    }

    private DockerVersion dockerVersion(Version version) {
        return DockerVersion.builder().apiVersion(version.apiVersion()).arch(version.arch()).gitCommit(version.gitCommit()).goVersion(version.goVersion()).kernelVersion(version.kernelVersion()).os(version.os()).version(version.version()).build();
    }

    private String dockerHost() {
        String host = this.dockerHost.host();
        if (host.startsWith("unix://")) {
            return host;
        }
        return "tcp://" + host;
    }

    @Override
    protected ScheduledFuture<?> schedule(Runnable runnable, ScheduledExecutorService executorService) {
        return executorService.scheduleWithFixedDelay(runnable, 0L, this.interval, this.timeUnit);
    }

    private String exec(String command) {
        try {
            Process process = Runtime.getRuntime().exec(command);
            return CharStreams.toString((Readable)new InputStreamReader(process.getInputStream(), Charsets.UTF_8));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

