/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InterruptingScheduledService
extends AbstractIdleService {
    private static final Logger log = LoggerFactory.getLogger(InterruptingScheduledService.class);
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(this.serviceName() + "-%d").build();
    private final ScheduledExecutorService executorService = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)((ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, this.threadFactory)), (long)0L, (TimeUnit)TimeUnit.SECONDS);
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            try {
                InterruptingScheduledService.this.beforeIteration();
                InterruptingScheduledService.this.runOneIteration();
            }
            catch (InterruptedException e) {
                log.debug("scheduled service interrupted: {}", (Object)InterruptingScheduledService.this.serviceName());
            }
            catch (Exception e) {
                if (e.getCause() instanceof InterruptedException) {
                    log.debug("scheduled service interrupted: {}", (Object)InterruptingScheduledService.this.serviceName());
                }
                log.warn("scheduled service threw exception: {}", (Object)InterruptingScheduledService.this.serviceName(), (Object)e);
            }
        }
    };
    private ScheduledFuture<?> future;

    protected void beforeIteration() throws InterruptedException {
    }

    protected abstract void runOneIteration() throws InterruptedException;

    protected void startUp() throws Exception {
        this.future = this.schedule(this.runnable, this.executorService);
    }

    protected void shutDown() throws Exception {
        if (this.future != null) {
            this.future.cancel(true);
        }
        this.executorService.shutdownNow();
        this.executorService.awaitTermination(1L, TimeUnit.DAYS);
    }

    protected abstract ScheduledFuture<?> schedule(Runnable var1, ScheduledExecutorService var2);
}

