/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.spotify.helios.agent.SignalAwaitingService;
import com.spotify.helios.common.Json;
import com.spotify.helios.servicescommon.coordination.NodeUpdaterFactory;
import com.spotify.helios.servicescommon.coordination.Paths;
import com.spotify.helios.servicescommon.coordination.ZooKeeperNodeUpdater;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class LabelReporter
extends SignalAwaitingService {
    private static final int RETRY_INTERVAL_MILLIS = 1000;
    private final Map<String, String> labels;
    private final ZooKeeperNodeUpdater nodeUpdater;

    public LabelReporter(String host, Map<String, String> labels, NodeUpdaterFactory nodeUpdaterFactory, CountDownLatch zkRegistrationSignal) {
        super(zkRegistrationSignal);
        this.labels = labels;
        this.nodeUpdater = nodeUpdaterFactory.create(Paths.statusHostLabels(host));
    }

    @Override
    protected void runOneIteration() throws InterruptedException {
        boolean successful = this.nodeUpdater.update(Json.asBytesUnchecked(this.labels));
        if (successful) {
            this.stopAsync();
        }
    }

    @Override
    protected ScheduledFuture<?> schedule(Runnable runnable, ScheduledExecutorService executorService) {
        return executorService.scheduleWithFixedDelay(runnable, 0L, 1000L, TimeUnit.MILLISECONDS);
    }
}

