/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.spotify.helios.agent.Agent;
import com.spotify.helios.common.descriptors.PortMapping;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortAllocator {
    private static final Logger log = LoggerFactory.getLogger(Agent.class);
    private int i = 0;
    private final List<Integer> potentialPorts;

    public PortAllocator(int start, int end) {
        this.potentialPorts = IntStream.range(start, end).boxed().collect(Collectors.toList());
        Collections.shuffle(this.potentialPorts);
    }

    public Map<String, Integer> allocate(Map<String, PortMapping> ports, Set<Integer> used) {
        return this.allocate0(ports, Sets.newHashSet(used));
    }

    private Map<String, Integer> allocate0(Map<String, PortMapping> mappings, Set<Integer> used) {
        ImmutableMap.Builder allocation = ImmutableMap.builder();
        for (Map.Entry<String, PortMapping> entry : mappings.entrySet()) {
            String name = entry.getKey();
            PortMapping portMapping = entry.getValue();
            Integer externalPort = portMapping.getExternalPort();
            if (!(externalPort == null ? !this.allocateDynamic((ImmutableMap.Builder<String, Integer>)allocation, used, name) : !this.allocateStatic((ImmutableMap.Builder<String, Integer>)allocation, used, name, externalPort))) continue;
            return null;
        }
        return allocation.build();
    }

    private boolean allocateStatic(ImmutableMap.Builder<String, Integer> allocation, Set<Integer> used, String name, Integer port) {
        if (used.contains(port)) {
            return false;
        }
        used.add(port);
        allocation.put((Object)name, (Object)port);
        return true;
    }

    private boolean allocateDynamic(ImmutableMap.Builder<String, Integer> allocation, Set<Integer> used, String name) {
        for (int i = 0; i < this.potentialPorts.size(); ++i) {
            Integer port = this.nextPotentialPort();
            if (used.contains(port) || !this.portAvailable(port)) continue;
            used.add(port);
            allocation.put((Object)name, (Object)port);
            return true;
        }
        return false;
    }

    private Integer nextPotentialPort() {
        if (this.i >= this.potentialPorts.size()) {
            this.i = 0;
        }
        Integer nextPort = this.potentialPorts.get(this.i);
        ++this.i;
        return nextPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean portAvailable(int port) {
        ServerSocket s = null;
        try {
            s = new ServerSocket(port);
            boolean bl = true;
            return bl;
        }
        catch (IOException ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    log.error("Couldn't close socket on port {} when checking availability: {}", (Object)port, (Object)e);
                }
            }
        }
    }
}

