/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.agent;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reaper {
    private final Logger log = LoggerFactory.getLogger(Reaper.class);
    private final DockerClient docker;
    private final String prefix;

    public Reaper(DockerClient docker, String namespace) {
        this.docker = docker;
        this.prefix = "/" + namespace;
    }

    public void reap(Supplier<Set<String>> active) throws InterruptedException {
        try {
            this.reap0(active);
        }
        catch (DockerException e) {
            this.log.error("reaping failed", (Throwable)e);
        }
    }

    private void reap0(Supplier<Set<String>> activeSupplier) throws DockerException, InterruptedException {
        ArrayList candidates = Lists.newArrayList();
        List containers = this.docker.listContainers(new DockerClient.ListContainersParam[0]);
        for (Container container : containers) {
            for (String name : container.names()) {
                if (!name.startsWith(this.prefix)) continue;
                candidates.add(container.id());
            }
        }
        Set active = (Set)activeSupplier.get();
        for (String candidate : candidates) {
            if (active.contains(candidate)) continue;
            this.reap(candidate);
        }
    }

    private void reap(String containerId) throws InterruptedException, DockerException {
        this.log.info("reaping {}", (Object)containerId);
        this.docker.killContainer(containerId);
    }
}

